import {Injectable} from '@angular/core';
import {ActivatedRoute, ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot, UrlTree} from '@angular/router';
import {ProcessService} from "@pas/xuml-communication";
import {NotificationService} from "@pas/app-core";

@Injectable({
    providedIn: 'root'
})
export class InstanceGuard implements CanActivate {

    constructor(
        private router: Router,
        private route:  ActivatedRoute,
        private process: ProcessService,
        private notification: NotificationService
    ) {
        this.router.onSameUrlNavigation = 'reload';
    }

    async canActivate(
        routeSnapshot: ActivatedRouteSnapshot,
        state: RouterStateSnapshot): Promise<boolean|UrlTree> {
        const processName = routeSnapshot.data.processName;
        const instanceId = routeSnapshot.params.instanceId;

        try {
            routeSnapshot.data.instance.value = await this.process.getInstance(processName, instanceId);

            if (routeSnapshot.data.instance.value == null) {
                this.notification.sendError('Instance not found');
                return this.router.navigate([processName], {
                    relativeTo: this.route,
                    replaceUrl: true
                });
            }

        } catch (error) {
            this.notification.sendNotification({
                type: 'error',
                message: error.message,
                data: {
                    type: 'ProcessInstance',
                    error: error
                }
            });
            return this.router.navigate([processName], {
                relativeTo: this.route,
                replaceUrl: true
            });
        }

        return true;
    }

}
