import {Component, OnInit} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {DataListComponentObject} from "@pas/form-elements";
import {SecurityService} from "@pas/app-core";

@Component({
  templateUrl: './select-task.component.html'
})
export class SelectTaskComponent implements OnInit {
  public processName = '';
  public instanceId = '';
  public currentTasks: DataListComponentObject[] = [];

  constructor (
      private route: ActivatedRoute,
      private router: Router,
      private security: SecurityService
  ) {
    this.router.onSameUrlNavigation = 'reload';
  }

  ngOnInit() {
    this.route.data.subscribe(data => {
      this.processName = data.processName;
      this.instanceId = data.instance.value.id;

      const authorizedTasks = data.instance._meta.currentTasks.filter(name => {
        const resourceId = "process/" + this.processName + "/" + name;
        return (this.security.isAuthorized(resourceId, "read") || this.security.isAuthorized(resourceId, "write"));
      });

      const tasks: DataListComponentObject[] = [];
      for (const task of authorizedTasks) {
        tasks.push({
          key: task,
          label: task, /* integrate translation here */
          icon: 'task' /* add custom icon here */
        })
      }
      this.currentTasks = tasks;
    });
  }

  public onAction(item): void {
    this.router.navigate([this.processName, this.instanceId, item.key]);
  }
}