/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractListModel;

public class SortedListModel<T>
extends AbstractListModel {
    private TreeSet<T> list;

    public SortedListModel(TreeSet<T> list) {
        this.list = list;
    }

    public SortedListModel(Comparator<T> comparator) {
        this.list = new TreeSet<T>(comparator);
    }

    public SortedListModel() {
        this.list = new TreeSet(new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                return t1.toString().compareToIgnoreCase(t2.toString());
            }
        });
    }

    public void add(T s) {
        this.list.add(s);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    public void remove(T s) {
        this.list.remove(s);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    public void removeAll() {
        this.list.clear();
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    public void addAll(Collection<T> data) {
        if (data != null) {
            this.list.addAll(data);
            this.fireContentsChanged(this, 0, this.list.size() - 1);
        }
    }

    public void clear() {
        this.list.clear();
        this.fireContentsChanged(this, 0, 0);
    }

    public Collection<T> values() {
        return this.list;
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public Object getElementAt(int index) {
        Iterator<T> iterator = this.list.iterator();
        T result = iterator.next();
        for (int i = 0; i < index; ++i) {
            result = iterator.next();
        }
        return result;
    }
}

