/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.event.DirectorySelectedEvent;
import ch.e2e.swing.event.DirectorySelectedEventMulticaster;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.filechooser.DirectoryField;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.FileListModel;
import ch.e2e.swing.model.FileListModelExtension;
import ch.e2e.swing.renderer.FileListCellRenderer;
import ch.e2e.swing.util.DirectoryFilter;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DirectoryList
extends JPanel
implements DirectorySelectedListener,
ListSelectionListener,
FocusListener {
    private JList list;
    private Color selectionBackground;
    private FileListModel model;
    private Directory selectedDirectory;
    private DirectorySelectedListener directorySelectedListener;
    private ActionListener actionListener;
    private int selectedIndex = -1;
    private boolean openDirectories = false;
    private Directory root;
    private boolean hasFocus = false;
    private boolean fireDirectorySelected = true;

    public DirectoryList() {
        super(new BorderLayout());
        this.createGui();
        this.addEventHandler();
    }

    public FileListModel getModel() {
        return this.model;
    }

    public void setModelExtension(FileListModelExtension modelExtension) {
        this.model.setExtension(modelExtension);
        ListCellRenderer cellRenderer = this.list.getCellRenderer();
        if (cellRenderer instanceof FileListCellRenderer) {
            FileListCellRenderer renderer = (FileListCellRenderer)cellRenderer;
            renderer.setFileListModelExtension(modelExtension);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.list.removeListSelectionListener(listener);
    }

    public void setDirectoryFilter(DirectoryFilter fileFilter) {
        this.model.setSelectedFileFilter(fileFilter);
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.addListener(this.directorySelectedListener, listener);
        if (listener instanceof DirectoryField) {
            final DirectoryField directoryField = (DirectoryField)listener;
            directoryField.addInputFieldListener(new InputFieldListener(){

                @Override
                public void inputFieldChanged(InputFieldEvent e) {
                    if (!DirectoryList.this.hasFocus) {
                        DirectoryList.this.fireDirectorySelected = false;
                        DirectoryList.this.setSelectedDirectory(directoryField.getSelectedDirectory());
                        DirectoryList.this.fireDirectorySelected = true;
                    }
                }
            });
        }
    }

    public void removeDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directorySelectedListener = DirectorySelectedEventMulticaster.removeListener(this.directorySelectedListener, listener);
    }

    @Override
    public final void directorySelected(DirectorySelectedEvent event) {
        this.setParentDirectory(event.getDirectory());
    }

    public void setParentDirectory(File parentDirectory) {
        this.setParentDirectory(Directory.getDirectory(parentDirectory));
    }

    public void setSelectedDirectory(File directory) {
        Directory dir = directory == null ? null : Directory.getDirectory(directory);
        this.setSelectedDirectory(dir);
    }

    private void setSelectedDirectory(Directory directory) {
        this.list.removeListSelectionListener(this);
        this.selectedIndex = directory == null ? -1 : this.model.indexOf(directory.getDir());
        if (this.selectedIndex == -1) {
            this.selectedDirectory = null;
            this.list.clearSelection();
        } else {
            this.selectedDirectory = directory;
            this.list.setSelectedIndex(this.selectedIndex);
        }
        this.list.addListSelectionListener(this);
        this.scrollRectToVisible();
        if (this.fireDirectorySelected) {
            this.fireDirectorySelected(this.selectedDirectory);
        }
    }

    private void setParentDirectory(Directory selectedDirectory) {
        this.selectedDirectory = selectedDirectory;
        this.model.setSelectedDirectory(selectedDirectory);
        this.selectedIndex = -1;
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    @Override
    public final void valueChanged(ListSelectionEvent event) {
        int newIndex = this.list.getSelectedIndex();
        if (newIndex != this.selectedIndex) {
            this.selectedIndex = newIndex;
            this.fireDirectorySelected((Directory)this.list.getSelectedValue());
        }
    }

    private void scrollRectToVisible() {
        if (this.selectedIndex != -1 && this.selectedIndex > this.list.getLastVisibleIndex()) {
            if (this.selectedIndex == this.model.getSize() - 1) {
                Point p = this.list.indexToLocation(this.selectedIndex);
                Dimension size = this.list.getSize();
                this.list.scrollRectToVisible(new Rectangle(p.x, p.y, 1, size.height - p.y));
            } else {
                Point p = this.list.indexToLocation(this.selectedIndex);
                this.list.scrollRectToVisible(new Rectangle(p.x, p.y - 1, 1, 0));
            }
        }
    }

    public void reload() {
        this.model.reload();
    }

    private void createGui() {
        this.model = new FileListModel();
        this.model.setIncludeDirectories(true);
        this.model.setSelectedFileFilter(null);
        this.list = new JList(this.model);
        this.list.setCellRenderer(new FileListCellRenderer());
        this.list.setAutoscrolls(true);
        this.list.setSelectionMode(0);
        this.selectionBackground = this.list.getSelectionBackground().darker();
        JScrollPane sp = new JScrollPane(this.list, 20, 30);
        this.add((Component)sp, "Center");
    }

    private void addEventHandler() {
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                DirectoryList.this.checkMouseSelection(event.getPoint());
                if (event.getClickCount() == 2) {
                    DirectoryList.this.checkMouseAction(event);
                }
            }
        });
        this.list.addListSelectionListener(this);
        this.list.addFocusListener(this);
    }

    private void checkMouseSelection(Point mousePosition) {
        int length = this.list.getModel().getSize();
        for (int i = 0; i < length; ++i) {
            if (!this.list.getCellBounds(i, i).contains(mousePosition)) continue;
            this.list.setSelectedIndex(i);
            break;
        }
    }

    private void checkMouseAction(MouseEvent event) {
        if (this.selectedIndex != -1) {
            int x = event.getX();
            int y = event.getY();
            if (this.list.getCellBounds(this.selectedIndex, this.selectedIndex).contains(x, y)) {
                this.doDirectoryAction();
            }
        }
    }

    private void doDirectoryAction() {
        this.selectedDirectory = (Directory)this.list.getSelectedValue();
        ActionListener action = this.model.getAction(this.selectedDirectory.getDir());
        if (this.openDirectories) {
            this.setParentDirectory(this.selectedDirectory);
        }
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 1001, "directoryListAction"));
        }
    }

    private void fireDirectorySelected(Directory selectedDirectory) {
        if (this.directorySelectedListener != null) {
            this.directorySelectedListener.directorySelected(new DirectorySelectedEvent(this, selectedDirectory));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.list.setSelectionBackground(this.selectionBackground);
        int newIndex = this.list.getSelectedIndex();
        if (newIndex > -1) {
            this.selectedIndex = newIndex;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        Color selectionBackground = this.selectionBackground.brighter();
        this.list.setSelectionBackground(selectionBackground);
    }

    public void setRoot(Directory root) {
        this.root = root;
    }

    public void setRoot(File root) {
        this.setRoot(Directory.getDirectory(root));
    }
}

