/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.EmptyBorder;

public class SelectSideEtchedBorder
extends EmptyBorder {
    public static final int LOWERED = 3;
    public static final int RAISED = 5;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 8;
    private Color col1;
    private Color col2;

    public SelectSideEtchedBorder(int sides) {
        this(sides, 3);
    }

    public SelectSideEtchedBorder(int sides, int type) {
        super((sides & 1) * 2, sides & 2, (sides & 4) / 2, (sides & 8) / 4);
        if (type == 3) {
            this.col1 = new Color(128, 128, 128);
            this.col2 = Color.white;
        } else {
            this.col1 = Color.white;
            this.col2 = new Color(128, 128, 128);
        }
    }

    public SelectSideEtchedBorder(int sides, int type, Color brightColor, Color darkColor) {
        super((sides & 1) * 2, sides & 2, (sides & 4) / 2, (sides & 8) / 4);
        if (type == 3) {
            this.col1 = darkColor;
            this.col2 = brightColor;
        } else {
            this.col1 = brightColor;
            this.col2 = darkColor;
        }
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        Color col = graphics.getColor();
        graphics.setColor(this.col1);
        if (this.top > 0) {
            graphics.drawLine(x, y, width - 1, y);
        }
        if (this.left > 0) {
            graphics.drawLine(x, y, x, y + height - 1);
        }
        if (this.bottom > 0) {
            graphics.drawLine(x, y + height - 2, width, y + height - 2);
        }
        if (this.right > 0) {
            graphics.drawLine(width - 2, x, width - 2, y + height - 1);
        }
        graphics.setColor(this.col2);
        if (this.top > 0) {
            graphics.drawLine(x + this.left / 2, y + 1, width - 1 - this.right, y + 1);
        }
        if (this.left > 0) {
            graphics.drawLine(x + 1, y + this.top, x + 1, y + height - 1 - this.bottom);
        }
        if (this.bottom > 0) {
            graphics.drawLine(x, y + height - 1, width, y + height - 1);
        }
        if (this.right > 0) {
            graphics.drawLine(width - 1, x, width - 1, y + height - 1);
        }
        graphics.setColor(col);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

