/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TextIcon
implements Icon,
PropertyChangeListener {
    public static final int ROTATION_NONE = 0;
    public static final int ROTATION_LEFT = 1;
    public static final int ROTATION_RIGHT = 2;
    private static final double NINETY_DEGREES = 1.5707963267948966;
    private static final int PADDING = 5;
    private final JComponent component;
    private final String text;
    private final int rotationHint;
    private int width;
    private int height;
    private Color foreground;

    public TextIcon(JComponent component, String text) {
        this(component, text, 0);
    }

    public TextIcon(JComponent component, String text, int rotationHint) {
        this.component = component;
        this.text = text;
        this.rotationHint = rotationHint;
        this.calculateDimension();
        component.addPropertyChangeListener("font", this);
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setFont(c.getFont());
        g2d.setColor(this.foreground == null ? c.getForeground() : this.foreground);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        switch (this.rotationHint) {
            case 1: {
                g2d.translate(x + this.width, y + this.height);
                g2d.rotate(-1.5707963267948966);
                g2d.drawString(this.text, 5, -fm.getDescent() + fm.getHeight() / 2);
                g2d.rotate(1.5707963267948966);
                g2d.translate(-(x + this.width), -(y + this.height));
                break;
            }
            case 2: {
                g2d.translate(x, y);
                g2d.rotate(1.5707963267948966);
                g2d.drawString(this.text, 5, fm.getDescent());
                g2d.rotate(-1.5707963267948966);
                g2d.translate(-x, -y);
                break;
            }
            default: {
                g2d.drawString(this.text, x, y + fm.getAscent());
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.calculateDimension();
    }

    private void calculateDimension() {
        int oldWidth = this.width;
        int oldHeight = this.height;
        FontMetrics fm = this.component.getFontMetrics(this.component.getFont());
        if (this.rotationHint == 0) {
            this.width = fm.stringWidth(this.text);
            this.height = fm.getHeight();
        } else {
            this.width = 0;
            this.height = fm.stringWidth(this.text) + 10;
        }
        if (oldHeight != this.height || oldWidth != this.width) {
            this.component.invalidate();
        }
    }
}

