/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.InputNumberField;
import ch.e2e.swing.document.IntegerFieldDocument;

public class InputIntegerField
extends InputNumberField {
    public InputIntegerField(int min, int max, int increment, int startValue) {
        super(new IntegerFieldDocument(min, max), min, max, increment);
        this.initialize();
        this.setContent(new Integer(startValue));
    }

    public InputIntegerField(int min, int max, int increment) {
        super(new IntegerFieldDocument(min, max), min, max, increment);
        this.initialize();
    }

    public InputIntegerField(int min, int max) {
        this(min, max, 0);
    }

    public void setValue(int value) {
        this.setContent(new Double(value));
    }

    public void setValue(Object value) {
        this.setContent(value);
    }

    public Object getValue() {
        return this.getContent();
    }

    @Override
    public void setContent(Object value) {
        if (value instanceof Double || value == null) {
            super.setContent(value);
        } else {
            super.setContent(new Double(((Integer)value).doubleValue()));
        }
    }

    @Override
    public Object getContent() {
        Object value = super.getContent();
        if (value != null) {
            value = ((Double)value).isNaN() ? null : new Integer(((Double)value).intValue());
        }
        return value;
    }

    private void initialize() {
        this.setEmptyValue(-2.147483648E9);
        boolean beepOnError = this.isBeepOnError();
        this.setBeepOnError(false);
        this.setContent(new Double(-2.147483648E9));
        this.setGroupingUsed(false);
        this.setBeepOnError(beepOnError);
    }
}

