/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.print;

import ch.e2e.print.ComponentPrinter;
import ch.e2e.print.PrintJob;
import ch.e2e.print.TablePrinter;
import ch.e2e.print.TextPanePrinter;
import ch.e2e.swing.PrintDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.print.Printable;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextPane;

public class PrintService {
    private static PrintService printService = new PrintService();

    private PrintService() {
    }

    public static void print(Object printableObject, Frame owner) throws PrintException {
        PrintJob printJob;
        if (printableObject != null && (printJob = printService.getPrintJob(owner)) != null) {
            if (printableObject instanceof Printable) {
                printService.print((Printable)printableObject, printJob);
            } else if (printableObject instanceof JTextPane) {
                printService.printTextPane((JTextPane)printableObject, printJob);
            } else if (printableObject instanceof JTable) {
                printService.printTable((JTable)printableObject, printJob);
            } else if (printableObject instanceof Component) {
                printService.printComponent((Component)printableObject, printJob);
            }
        }
    }

    public static void print(Object printableObject, JDialog owner) throws PrintException {
        PrintJob printJob;
        if (printableObject != null && (printJob = printService.getPrintJob(owner)) != null) {
            if (printableObject instanceof Printable) {
                printService.print((Printable)printableObject, printJob);
            } else if (printableObject instanceof JTextPane) {
                printService.printTextPane((JTextPane)printableObject, printJob);
            } else if (printableObject instanceof JTable) {
                printService.printTable((JTable)printableObject, printJob);
            } else if (printableObject instanceof Component) {
                printService.printComponent((Component)printableObject, printJob);
            }
        }
    }

    private PrintJob getPrintJob(Frame owner) {
        return PrintDialog.printDialog(owner);
    }

    private PrintJob getPrintJob(JDialog owner) {
        return PrintDialog.printDialog(owner);
    }

    private void printComponent(Component component, PrintJob printJob) throws PrintException {
        DocAttributeSet docAttributes = printJob.getDocAttributeSet();
        MediaPrintableArea printableArea = (MediaPrintableArea)docAttributes.get(MediaPrintableArea.class);
        PrintRequestAttributeSet printAttributes = printJob.getPrintAttributes();
        OrientationRequested orientation = (OrientationRequested)printAttributes.get(OrientationRequested.class);
        Printable printable = ComponentPrinter.getPrintable(component, printableArea, orientation);
        this.print(printable, printJob);
    }

    private void printTable(JTable table, PrintJob printJob) throws PrintException {
        DocAttributeSet docAttributes = printJob.getDocAttributeSet();
        MediaPrintableArea printableArea = (MediaPrintableArea)docAttributes.get(MediaPrintableArea.class);
        PrintRequestAttributeSet printAttributes = printJob.getPrintAttributes();
        OrientationRequested orientation = (OrientationRequested)printAttributes.get(OrientationRequested.class);
        Printable printable = TablePrinter.getPrintable(table, printableArea, orientation);
        this.print(printable, printJob);
    }

    private void printTextPane(JTextPane textPane, PrintJob printJob) throws PrintException {
        this.print(TextPanePrinter.getTextPanePrinter(textPane), printJob);
    }

    private void print(Printable printable, PrintJob printJob) throws PrintException {
        SimpleDoc printDoc = new SimpleDoc(printable, DocFlavor.SERVICE_FORMATTED.PRINTABLE, printJob.getDocAttributeSet());
        printJob.getDocPrintJob().print(printDoc, printJob.getPrintAttributes());
    }
}

