/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.io.FileUtilities;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.PreprocessorOption;
import ch.e2e.util.StringTools;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Utilities {
    private Utilities() {
    }

    public static Object createValue(Element element) {
        Object result = null;
        String type = element.getAttribute("type");
        String value = element.hasAttribute("value") ? element.getAttribute("value") : element.getFirstChild().getNodeValue();
        try {
            Class<?> sourceType = Class.forName(type);
            result = Utilities.createValue(value, sourceType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Object createValue(String value, Class sourceType) {
        File result = null;
        if (sourceType.equals(File.class)) {
            result = new File(value.replace('\\', '/'));
        } else {
            try {
                Constructor typeConstructor = sourceType.getConstructor(String.class);
                result = typeConstructor.newInstance(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static E2ETest createTest(TestType testType) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        E2ETest result = null;
        if (testType.isTest()) {
            result = (E2ETest)testType.newInstance();
            result.setName("executeTest");
            result.setType(testType);
        }
        return result;
    }

    public static void readOptions(NodeList options, boolean inherited, OptionContainer optionContainer) {
        if (options != null) {
            int length = options.getLength();
            for (int i = 0; i < length; ++i) {
                Utilities.readOption((Element)options.item(i), inherited, optionContainer);
            }
        }
    }

    public static void readOption(Element optionElement, boolean inherited, OptionContainer optionContainer) {
        String key = optionElement.getAttribute("name");
        Option option = optionContainer.getOptions().get(key);
        if (option != null) {
            option.initialize(optionElement);
            option.setInherited(inherited);
        }
    }

    public static void mergeOptions(OptionContainer from, OptionContainer to) {
        if (from != null) {
            Option copy;
            for (String key : from.getOptions().keySet()) {
                copy = from.getOptions().get(key).createCopy();
                copy.setInherited(true);
                if (to.getOptions().containsKey(key)) {
                    to.getOptions().get(key).merge(copy);
                    continue;
                }
                to.getOptions().put(key, copy);
            }
            for (String key : from.getAdvancedOptions().keySet()) {
                copy = from.getAdvancedOptions().get(key).createCopy();
                copy.setInherited(true);
                if (to.getAdvancedOptions().containsKey(key)) {
                    to.getAdvancedOptions().get(key).merge(copy);
                    continue;
                }
                to.getAdvancedOptions().put(key, copy);
            }
        }
    }

    public static Object getOptionValue(String key, OptionContainer optionContainer, Map<String, String> runProperties) {
        Object result = null;
        if (optionContainer.getOptions().containsKey(key)) {
            result = Utilities.getReplacedValue(optionContainer.getOptions().get(key), runProperties);
        } else if (optionContainer.getAdvancedOptions().containsKey(key)) {
            result = Utilities.getReplacedValue(optionContainer.getAdvancedOptions().get(key), runProperties);
        }
        return result;
    }

    private static Object getReplacedValue(Option option, Map<String, String> runProperties) {
        Object result = null;
        String value = option.getValue() == null ? (option.getDefaultValue() == null ? null : option.getDefaultValue().toString()) : option.getValue().toString();
        if (value != null) {
            String newValue = StringTools.replaceProperties((String)value, runProperties);
            result = value.equals(newValue) ? (option.getValue() == null ? option.getDefaultValue() : option.getValue()) : option.createValue(newValue);
        }
        return result;
    }

    public static void deleteEmptyParents(File file) {
        File parent;
        File file2 = parent = file.isDirectory() ? file : file.getParentFile();
        while (parent != null && !FileUtilities.containsFiles((File)parent)) {
            if (!parent.delete()) {
                int n = 42;
            }
            parent = parent.getParentFile();
        }
    }

    public static Map<String, String> collectProperties(Testable test) {
        HashMap<String, String> result = new HashMap<String, String>(test.getProperties());
        for (Testable parent = test.getParent(); parent != null; parent = parent.getParent()) {
            for (String key : parent.getProperties().keySet()) {
                if (result.containsKey(key)) continue;
                result.put(key, parent.getProperties().get(key));
            }
        }
        return result;
    }

    public static void insertProperties(E2ETestcase test) {
        Map<String, String> properties = Utilities.collectProperties(test);
        Utilities.insertProperties(test, properties);
    }

    public static void insertProperties(E2ETestcase test, Map<String, String> properties) {
        Utilities.insertProperties(test.getTest(), properties);
        if (test.getResult() != null) {
            for (ResultCompare compare : test.getTest().getResult().getResultCompares()) {
                Utilities.insertProperties(compare, properties);
            }
        }
    }

    public static void insertProperties(OptionContainer test, Map<String, String> properties) {
        Utilities.insertProperties(test.getOptions(), properties);
        Utilities.insertProperties(test.getAdvancedOptions(), properties);
    }

    public static void replaceProperties(E2ETestcase test) {
        Map<String, String> properties = Utilities.collectProperties(test);
        Utilities.replaceProperties(test, properties);
    }

    public static void insertProperties(Map<String, Option> options, Map<String, String> properties) {
        properties = Utilities.sortByValueLength(properties);
        for (String key : options.keySet()) {
            String value;
            Option option = options.get(key);
            if (option.getValue() == null) {
                if (option.getDefaultValue() == null) continue;
                value = option.getDefaultValue().toString();
                for (String propertyKey : properties.keySet()) {
                    String propertyValue = properties.get(propertyKey);
                    if (!value.contains(propertyValue)) continue;
                    value = value.replace(propertyValue, "${" + propertyKey + "}");
                    option.setDefaultValue(option.createValue(value));
                }
                continue;
            }
            if (!Utilities.containsPath(option)) continue;
            value = option.getValue().toString();
            boolean done = false;
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String propertyValue = StringTools.replaceProperties((String)entry.getValue(), properties);
                propertyValue = propertyValue.replace('/', File.separatorChar);
                if (!value.startsWith((propertyValue = propertyValue.replace('\\', File.separatorChar)) + File.separatorChar)) continue;
                value = value.replace(propertyValue, "${" + entry.getKey() + "}");
                done = true;
                break;
            }
            if (!done) {
                value = Utilities.replaceRelativePath(value, properties);
            }
            option.setValueWithoutNotification(option.createValue(value));
        }
    }

    private static boolean containsPath(Option option) {
        return option instanceof FileOption || option instanceof PreprocessorOption || option instanceof CompareFileOption;
    }

    public static String replaceRelativePath(String value, Map<String, String> properties) {
        String key = "project.folder";
        String projectFolder = properties.get("project.folder");
        if (projectFolder == null) {
            projectFolder = System.getProperties().getProperty("project.folder");
        }
        String property = projectFolder.replace("\\", "/");
        value = value.replace("\\", "/");
        String[] split = property.split("/");
        for (int i = split.length - 1; i >= 0; --i) {
            StringBuilder pathBuilder = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                pathBuilder.append(split[j]);
                pathBuilder.append("/");
            }
            String path = pathBuilder.toString();
            if (!value.startsWith(path)) continue;
            value = value.replace(path, "");
            StringBuilder valueBuilder = new StringBuilder();
            valueBuilder.append("${project.folder}/");
            for (int k = i; k < split.length - 1; ++k) {
                valueBuilder.append("..");
                valueBuilder.append("/");
            }
            value = valueBuilder.toString() + value;
            break;
        }
        return value;
    }

    static Map<String, String> sortByValueLength(final Map<String, String> map) {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                String left = (String)map.get(str1);
                if (left == null) {
                    return 1;
                }
                if (left.equals(map.get(str2))) {
                    return 0;
                }
                if (left.length() <= ((String)map.get(str2)).length()) {
                    return 1;
                }
                return -1;
            }
        };
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(comparator);
        sortedMap.putAll(map);
        return sortedMap;
    }

    private static void replaceProperties(E2ETestcase test, Map<String, String> properties) {
        Utilities.replaceProperties(test.getTest().getOptions(), properties);
        Utilities.replaceProperties(test.getTest().getAdvancedOptions(), properties);
        if (test.getTest().getResult() != null) {
            for (ResultCompare compare : test.getTest().getResult().getResultCompares()) {
                Utilities.replaceProperties(compare.getOptions(), properties);
                Utilities.replaceProperties(compare.getAdvancedOptions(), properties);
            }
        }
    }

    private static void replaceProperties(Map<String, Option> options, Map<String, String> properties) {
        for (String key : options.keySet()) {
            String newValue;
            String value;
            Option option = options.get(key);
            if (option.getValue() == null) {
                if (option.getDefaultValue() == null || (value = option.getDefaultValue().toString()).equals(newValue = StringTools.replaceProperties((String)value, properties))) continue;
                option.setDefaultValue(option.createValue(newValue));
                continue;
            }
            value = option.getValue().toString();
            if (value.equals(newValue = StringTools.replaceProperties((String)value, properties))) continue;
            option.setValueWithoutNotification(option.createValue(newValue));
        }
    }
}

