/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.io.FileUtilities;
import ch.e2e.test.AbstractResultCompare;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.TestResult;
import ch.e2e.test.options.CompareFileOption;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DirectoryCompare
extends AbstractResultCompare {
    private static final int STRUCTURE_EQUAL = 0;
    private static final String KEY_OPTION_REFERENCE_FOLDER = "directory.compare.reference.folder";
    private static final String KEY_OPTION_TEST_FOLDER = "directory.compare.test.folder";
    private int type;

    @Override
    public void init(Element options) {
        super.init(options);
        this.checkOptions(options);
    }

    @Override
    public void setGlobalTestOptions(Element options) {
        super.setGlobalTestOptions(options);
        this.checkOptions(options);
    }

    @Override
    public void doTest(E2ETest e2eTest) throws Exception {
        switch (this.type) {
            case 0: {
                this.assertStructureEqual();
            }
        }
    }

    @Override
    public TestResult getTestResult(boolean includeHiddenData, Map<String, String> properties) {
        ArrayList<String> referencePaths = this.createRelativePaths(((CompareFile)((CompareFileOption)this.getOptions().get(KEY_OPTION_REFERENCE_FOLDER)).getValue()).getFile());
        ArrayList<String> testPaths = this.createRelativePaths(((CompareFile)((CompareFileOption)this.getOptions().get(KEY_OPTION_TEST_FOLDER)).getValue()).getFile());
        return this.getTestResult(referencePaths, testPaths);
    }

    @Override
    public void toXml(Element parent) {
        Element result = parent.getOwnerDocument().createElement("directoryCompare");
        result.setAttribute("compareType", "structure.equal");
        result.setAttribute("name", this.getName());
        this.getOptions().get(KEY_OPTION_REFERENCE_FOLDER).toXml("reference", result);
        this.getOptions().get(KEY_OPTION_TEST_FOLDER).toXml("test", result);
        parent.appendChild(result);
    }

    @Override
    public Element optionsToXml(boolean includeType, Document ownerDocument) {
        return null;
    }

    protected TestResult getTestResult(ArrayList<String> controlPaths, ArrayList<String> testPaths) {
        StringBuilder referenceData = new StringBuilder();
        StringBuilder testData = new StringBuilder();
        for (String controlPath : controlPaths) {
            referenceData.append(controlPath).append("\n");
            if (testPaths.contains(controlPath)) {
                testPaths.remove(controlPath);
                testData.append(controlPath).append("\n");
                continue;
            }
            testData.append("\n");
        }
        for (String testPath : testPaths) {
            referenceData.append("\n");
            testData.append(testPath);
        }
        return new TestResult(referenceData.toString(), testData.toString());
    }

    protected void assertStructureEqual(ArrayList<String> controlPaths, ArrayList<String> testPaths) {
        Assert.assertTrue((String)("Control file count = " + controlPaths.size() + ", Test file count = " + testPaths.size()), (testPaths.size() == controlPaths.size() ? 1 : 0) != 0);
        for (String controlPath : controlPaths) {
            testPaths.remove(controlPath);
        }
        Assert.assertTrue((String)"The two folders does not contain the same files.", (testPaths.size() == 0 ? 1 : 0) != 0);
    }

    private void checkOptions(Element options) {
        NodeList testFiles;
        this.type = this.getType(options.getAttribute("compareType"));
        NodeList referenceDirs = options.getElementsByTagName("control");
        if (referenceDirs == null || referenceDirs.getLength() == 0) {
            referenceDirs = options.getElementsByTagName("reference");
        }
        if (referenceDirs != null && referenceDirs.getLength() == 1) {
            CompareFile referenceDir = new CompareFile((Element)referenceDirs.item(0));
            this.getOptions().get(KEY_OPTION_REFERENCE_FOLDER).setValue(referenceDir);
        }
        if ((testFiles = options.getElementsByTagName("test")) != null && testFiles.getLength() == 1) {
            CompareFile testDir = new CompareFile((Element)testFiles.item(0));
            this.getOptions().get(KEY_OPTION_TEST_FOLDER).setValue(testDir);
        }
    }

    private void assertStructureEqual() {
        ArrayList<String> controlPaths = this.createRelativePaths(((CompareFile)((CompareFileOption)this.getOptions().get(KEY_OPTION_REFERENCE_FOLDER)).getValue()).getFile());
        ArrayList<String> testPaths = this.createRelativePaths(((CompareFile)((CompareFileOption)this.getOptions().get(KEY_OPTION_TEST_FOLDER)).getValue()).getFile());
        this.assertStructureEqual(controlPaths, testPaths);
    }

    private ArrayList<String> createRelativePaths(File basedir) {
        File[] files = FileUtilities.getAllFilesAndDirectories((File)basedir, (boolean)true);
        return this.getRelativePaths(files, basedir);
    }

    private int getType(String attribute) {
        int type = attribute.equalsIgnoreCase("structure.equal") ? 0 : 0;
        return type;
    }

    @Override
    protected void createOptions() {
        CompareFileOption testFolder = new CompareFileOption("Test folder", KEY_OPTION_TEST_FOLDER, 0);
        this.addOption(KEY_OPTION_TEST_FOLDER, testFolder);
        CompareFileOption referenceFolder = new CompareFileOption("Reference folder", KEY_OPTION_REFERENCE_FOLDER, 0);
        this.addOption(KEY_OPTION_REFERENCE_FOLDER, referenceFolder);
    }
}

