/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import java.io.File;
import org.w3c.dom.Element;

public class CompareFile {
    private File file;
    private boolean directory;

    public CompareFile(File file) {
        this.file = file;
        this.directory = file.isDirectory();
    }

    public CompareFile(Element fileElement) {
        if (fileElement.hasAttribute("file")) {
            this.file = new File(fileElement.getAttribute("file"));
            this.directory = false;
        } else if (fileElement.hasAttribute("dir")) {
            this.file = new File(fileElement.getAttribute("dir"));
            this.directory = true;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (!this.file.equals(file)) {
            this.file = file;
        }
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        if (this.directory ^ directory) {
            this.directory = directory;
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CompareFile && ((CompareFile)obj).file.equals(this.file) && ((CompareFile)obj).directory == this.directory;
    }

    public String toString() {
        return this.file.isAbsolute() ? this.file.getAbsolutePath() : this.file.getPath() + '|' + this.directory;
    }
}

