/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.impl.JMSAddOnHelper;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.naming.NamingException;

public class MessageReceiver {
    private Map<String, MessageConsumer> consumers = new HashMap<String, MessageConsumer>();
    private Map<String, Message> messages = new HashMap<String, Message>();
    private final Session session;
    private final ConnectionAdapter connection;

    public MessageReceiver(Session session, ConnectionAdapter connection) {
        this.session = session;
        this.connection = connection;
    }

    public Message receive(String destinationName, String selector, long milliSecondsToWait) throws NamingException, JMSException {
        JMSLogger.getInstance().debug("2", "Receiving message with session " + this.session + ".");
        MessageConsumer consumer = this.getMessageConsumer(destinationName, selector);
        Message message = milliSecondsToWait == -1L ? consumer.receiveNoWait() : consumer.receive(milliSecondsToWait);
        this.registerMessage(message, this.connection);
        return message;
    }

    public void close() {
        for (MessageConsumer consumer : this.consumers.values()) {
            try {
                consumer.close();
            }
            catch (JMSException e) {
                throw new BridgeException("Closing JMS message consumer failed", e, "JMS4");
            }
        }
        this.consumers.clear();
        this.messages.clear();
    }

    private MessageConsumer getMessageConsumer(String destinationName, String selector) throws JMSException, NamingException {
        String key = destinationName + selector;
        MessageConsumer consumer = this.consumers.get(key);
        if (consumer == null) {
            Destination destination = JMSAddOnHelper.getDestination(destinationName, this.session, this.connection.getInitialContext());
            consumer = this.session.createConsumer(destination, selector);
            this.consumers.put(key, consumer);
        }
        return consumer;
    }

    private void registerMessage(Message message, ConnectionAdapter connection) throws JMSException {
        if (message != null && !connection.isTransacted() && connection.getAcknowledgeMode() == 2) {
            this.messages.put(message.getJMSMessageID(), message);
        }
    }
}

