/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import ch.e2e.bridge.server.BridgeError;
import ch.e2e.bridge.server.BridgeErrorWrapper;
import ch.e2e.bridge.server.RequestInfo;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.session.Session;

public class Callback {
    public static native long invoke(String var0, long var1, long var3, long var5);

    public static native long invokeEx(String var0, long var1, long var3, long var5, Object var7);

    public static void invoke(String request, RecordItem input, RecordItem output, ArrayItem error) {
        Callback.invoke(request, input.getNativeItem(), output.getNativeItem(), error.getNativeItem());
    }

    public static void invoke(String request, RecordItem input, RecordItem output, ArrayItem error, RequestInfo requestInfo) {
        try {
            Callback.invokeEx(request, input.getNativeItem(), output.getNativeItem(), error.getNativeItem(), requestInfo);
        }
        catch (UnsatisfiedLinkError e) {
            JMSLogger.getInstance().debug("native callback", String.format("Runtime doesn't implement native callback '%s'.", e.getMessage()));
            Callback.invoke(request, input.getNativeItem(), output.getNativeItem(), error.getNativeItem());
        }
    }

    public static boolean failed(ArrayItem errorItem) {
        return errorItem.size() > 0;
    }

    public static BridgeError getBridgeError(Session session, ArrayItem errorItem) {
        return (BridgeError)session.createObject((RecordItem)errorItem.getItem(0L), BridgeErrorWrapper.class);
    }
}

