/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui;

import ch.e2e.builder.analyzer.gui.Logging;
import ch.e2e.builder.analyzer.gui.TransactionLogViewCard;
import ch.e2e.builder.analyzer.model.TransactionLog;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.E2EBuilderFrame;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class TransactionLogOverviewView
extends JScrollPane
implements TransactionLogViewCard,
HyperlinkListener,
Logging {
    private final E2EBuilderModule module;
    private JEditorPane pane;
    private TransactionLog transactionLog;

    public TransactionLogOverviewView(E2EBuilderModule module) {
        super(20, 30);
        this.module = module;
        this.createGui();
    }

    @Override
    public void setRoot(TransactionLogObject newRoot) {
        if (newRoot instanceof TransactionLog) {
            this.transactionLog = (TransactionLog)newRoot;
            this.loadTransactionLog();
        } else {
            this.pane.setText(null);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                this.pane.setPage(event.getURL());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void refresh() {
    }

    private void createGui() {
        this.pane = new JEditorPane();
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(this);
        this.setViewportView(this.pane);
    }

    private void loadTransactionLog() {
        this.pane.setText(null);
        this.setWaitCursor();
        try {
            if (!this.transactionLog.isLoaded()) {
                this.transactionLog.load();
                for (Throwable error : this.transactionLog.getErrors()) {
                    this.module.showWarning(error.getMessage());
                    logger.warning(error.getMessage());
                }
            }
            this.showOverview();
        }
        catch (Exception e) {
            E2EBuilderInfoDialog.error((String)e.getMessage());
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "setRoot", e);
        }
        finally {
            this.setDefaultCursor();
        }
    }

    private void showOverview() {
        URL url = this.transactionLog.getStatisticsFileUrl();
        if (url != null) {
            try {
                this.pane.getDocument().putProperty("stream", null);
                this.pane.setPage(url);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "newRoot", e);
            }
        }
    }

    private void setDefaultCursor() {
        Frame applicationFrame = E2EBuilder.getInstance().getApplicationFrame();
        if (applicationFrame instanceof E2EBuilderFrame) {
            ((E2EBuilderFrame)applicationFrame).setDefaultCursor();
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setWaitCursor() {
        Frame applicationFrame = E2EBuilder.getInstance().getApplicationFrame();
        if (applicationFrame instanceof E2EBuilderFrame) {
            ((E2EBuilderFrame)applicationFrame).setWaitCursor();
        } else {
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
        }
    }
}

