/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui;

import ch.e2e.builder.analyzer.Analyzer;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportNameSelection
extends E2EBuilderDialog {
    public static final String TITLE = ".import.name.selection.title";
    public static final String INTERNAL_TITLE = ".import.name.selection.internalTitle";
    public static final String SUBTITLE = ".import.name.selection.subtitle";
    private static final String NAME_LABEL_NAME = ".import.name.selection.name.label.name";
    private static final String EXISTING_NAMES_LABEL_NAME = ".import.name.selection.existing.names.label.name";
    private static HashMap<String, ImportNameSelection> instances = new HashMap();
    private JList existingNamesItem;
    private InputTextField nameItem;
    private DefaultListModel namesModel;
    private String logName;

    private ImportNameSelection(Analyzer analyzer, String translationPrefix) {
        super(analyzer.getTranslation(translationPrefix + TITLE), analyzer.getTranslation(translationPrefix + INTERNAL_TITLE), analyzer.getTranslation(translationPrefix + SUBTITLE), 3);
        this.createGui(analyzer, translationPrefix);
        this.addEventHandler();
    }

    public static String getNewName(String logName, Set<String> existingNames, Analyzer analyzer, String translationPrefix) {
        if (instances.get(translationPrefix) == null) {
            instances.put(translationPrefix, new ImportNameSelection(analyzer, translationPrefix));
        }
        return instances.get(translationPrefix).findName(logName, existingNames);
    }

    private String findName(String logName, Set<String> existingNames) {
        this.logName = logName;
        String name = null;
        this.namesModel.clear();
        for (String n : existingNames) {
            this.namesModel.addElement(n);
        }
        this.existingNamesItem.setSelectedValue(null, true);
        this.nameItem.setText(logName);
        this.setOkButtonEnabled(logName != null && logName.length() > 0);
        if (this.showDialog() == 1) {
            name = this.nameItem.getText() + " (" + logName + ")";
        }
        return name;
    }

    private void createGui(Analyzer analyzer, String translationPrefix) {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel namePanel = new JPanel(new GridLayout(2, 1));
        namePanel.add(ComponentFactory.createLabel((String)(translationPrefix + NAME_LABEL_NAME), (E2EBuilderModule)analyzer));
        this.nameItem = new InputTextField();
        namePanel.add((Component)this.nameItem);
        this.add(namePanel, "North");
        JPanel existingNamesPanel = new JPanel(new BorderLayout(3, 3));
        existingNamesPanel.add((Component)ComponentFactory.createLabel((String)(translationPrefix + EXISTING_NAMES_LABEL_NAME), (E2EBuilderModule)analyzer), "North");
        this.namesModel = new DefaultListModel();
        this.existingNamesItem = new JList(this.namesModel);
        this.existingNamesItem.setSelectionMode(0);
        existingNamesPanel.add((Component)new JScrollPane(this.existingNamesItem, 20, 30), "Center");
        this.add(existingNamesPanel, "Center");
    }

    private void addEventHandler() {
        this.nameItem.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                String text = ImportNameSelection.this.nameItem.getText();
                ImportNameSelection.this.setOkButtonEnabled(text.length() > 0);
            }
        });
        this.existingNamesItem.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                String name = (String)ImportNameSelection.this.existingNamesItem.getSelectedValue();
                if (name != null && (index = name.lastIndexOf(" (")) != -1) {
                    name = name.substring(0, index);
                }
                ImportNameSelection.this.nameItem.setText(name);
            }
        });
    }
}

