/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.resource;

import ch.e2e.resource.Logging;
import ch.e2e.util.StringTools;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Properties
extends java.util.Properties
implements Logging {
    private boolean exists = false;
    private String name;
    private String extension = ".properties";
    private File propertiesFile;
    private Locale locale = Locale.getDefault();
    private ArrayList addedProperties = new ArrayList();
    private ClassLoader classLoader;

    public Properties() {
    }

    public Properties(Locale locale) {
        this(locale, Properties.class.getClassLoader());
    }

    public Properties(Locale locale, ClassLoader classLoader) {
        this.locale = locale;
        this.classLoader = classLoader;
    }

    public Properties(File propertiesFile) {
        this.setPropertiesFile(propertiesFile, true);
    }

    public Properties(InputStream in) {
        this.loadProperties(in);
    }

    public Properties(String name) {
        this(name, Locale.getDefault(), Properties.class.getClassLoader());
    }

    public Properties(String name, ClassLoader classLoader) {
        this(name, Locale.getDefault(), classLoader);
    }

    public Properties(String name, Locale locale) {
        this(name, locale, Properties.class.getClassLoader());
    }

    public Properties(String name, Locale locale, ClassLoader classLoader) {
        this.name = name;
        this.locale = locale;
        this.classLoader = classLoader;
        try {
            this.fillPropertiesTable(ResourceBundle.getBundle(name, locale, classLoader));
            this.exists = true;
        }
        catch (MissingResourceException mrEx) {
            this.exists = false;
        }
    }

    public ClassLoader getUsedClassLoader() {
        return this.classLoader;
    }

    public boolean exists() {
        return this.exists;
    }

    public void reload() {
        this.reload(this.locale);
    }

    public void reload(Locale locale) {
        this.clear();
        this.locale = locale;
        if (this.propertiesFile == null) {
            this.fillPropertiesTable(ResourceBundle.getBundle(this.name, locale, this.classLoader));
        } else {
            this.loadPropertiesFromFile();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public void addProperties(Properties properties) {
        this.addedProperties.add(properties.getName());
        this.putAll((Map<?, ?>)properties);
    }

    public boolean containsProperties(String name) {
        return this.addedProperties.contains(name);
    }

    public Iterator getAddedProperties() {
        return this.addedProperties.iterator();
    }

    @Override
    public Object setProperty(String key, String value) {
        return super.setProperty(key, value);
    }

    public Object setProperty(String key, String[] value) {
        return this.put(key, StringTools.createArrayString(value));
    }

    public void setProperty(String key, Object value) {
        this.put(key, value.toString());
    }

    public void setProperty(String key, Color value) {
        this.put(key, StringTools.createColorString(value));
    }

    public void setProperty(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    public void setProperty(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public void setProperty(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void setProperty(String key, File file) {
        this.put(key, file.getAbsolutePath());
    }

    public void removeProperty(String key) {
        this.remove(key);
    }

    public String getString(String key) throws MissingResourceException {
        String result;
        Object value = this.get(key);
        if (value == null) {
            throw new MissingResourceException("resource not found", this.name, key);
        }
        if (value instanceof String[]) {
            StringBuffer arrayString = new StringBuffer("{");
            String[] array = (String[])value;
            for (int i = 0; i < array.length; ++i) {
                arrayString.append(array[i]);
                if (i >= array.length - 1) continue;
                arrayString.append(',');
            }
            arrayString.append("}");
            result = arrayString.toString();
        } else {
            result = value.toString();
        }
        return result;
    }

    public String getString(String key, String defaultValue) {
        String result;
        try {
            result = this.getString(key);
        }
        catch (MissingResourceException mrEx) {
            if (defaultValue != null) {
                this.put(key, defaultValue);
            }
            result = defaultValue;
        }
        return result;
    }

    public String[] getStringArray(String key) throws MissingResourceException {
        String[] result = null;
        Object value = this.get(key);
        if (value != null) {
            if (value instanceof String[]) {
                result = (String[])value;
            } else if (value instanceof String) {
                try {
                    String[] stringArray = StringTools.createStringArray((String)value);
                    result = stringArray;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            throw new MissingResourceException("resource not found", this.name, key);
        }
        return result;
    }

    public String[] getStringArray(String key, String[] defaultValue) {
        String value = (String)this.get(key);
        if (value == null) {
            this.put(key, StringTools.createArrayString(defaultValue));
        } else {
            try {
                defaultValue = StringTools.createStringArray(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public long getInteger(String key) throws MissingResourceException {
        String value = (String)this.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new MissingResourceException("resource not found", this.name, key);
    }

    public long getInteger(String key, long defaultValue) {
        String value = (String)this.get(key);
        if (value == null) {
            this.put(key, String.valueOf(defaultValue));
        } else {
            try {
                defaultValue = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) throws MissingResourceException {
        String value = (String)this.get(key);
        if (value != null) {
            try {
                return StringTools.createBoolean(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new MissingResourceException("resource not found", this.name, key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = (String)this.get(key);
        if (value == null) {
            this.put(key, String.valueOf(defaultValue));
        } else {
            defaultValue = StringTools.createBoolean(value);
        }
        return defaultValue;
    }

    public double getDouble(String key) throws MissingResourceException {
        String value = (String)this.get(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new MissingResourceException("resource not found", this.name, key);
    }

    public double getDouble(String key, double defaultValue) {
        String value = (String)this.get(key);
        if (value == null) {
            this.put(key, String.valueOf(defaultValue));
        } else {
            try {
                defaultValue = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Color getColor(String key) throws MissingResourceException {
        String value = (String)this.get(key);
        if (value != null) {
            try {
                return new Color(Integer.parseInt(value.substring(1), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new MissingResourceException("resource not found", this.name, key);
    }

    public Color getColor(String key, Color defaultValue) {
        String value = (String)this.get(key);
        if (value == null) {
            this.put(key, StringTools.createColorString(defaultValue));
        } else {
            try {
                defaultValue = new Color(Integer.parseInt(value.substring(1), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public File getFile(String key) throws MissingResourceException {
        String value = (String)this.get(key);
        if (value == null) {
            throw new MissingResourceException("No file for key " + key + "found.", this.getClass().getName(), key);
        }
        return new File(value);
    }

    public File getFile(String key, File defaultValue) throws MissingResourceException {
        String value = (String)this.get(key);
        if (value == null) {
            this.put(key, defaultValue.getAbsolutePath());
        } else {
            defaultValue = new File(value);
        }
        return defaultValue;
    }

    public void increase(String key, boolean increaseFraction) {
        String value = this.getString(key, "0");
        int integers = 0;
        boolean intValue = true;
        int index = 0;
        try {
            index = value.indexOf(46);
            intValue = index == -1;
            index = intValue ? value.length() : index;
            integers = Integer.parseInt(value.substring(0, index));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (increaseFraction) {
            int fractions = 0;
            try {
                fractions = Integer.parseInt(value.substring(index + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.put(key, String.valueOf(integers) + '.' + String.valueOf(++fractions));
        } else {
            ++integers;
            if (intValue) {
                this.put(key, String.valueOf(integers));
            } else {
                this.put(key, String.valueOf(integers) + value.substring(index));
            }
        }
    }

    public void updateDate(String key, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        this.put(key, formatter.format(new Date()));
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile, boolean load) {
        this.propertiesFile = propertiesFile;
        String filename = propertiesFile.getName();
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            this.name = filename;
            this.extension = "";
        } else {
            this.name = filename.substring(0, index);
            this.extension = filename.substring(index);
        }
        if (load) {
            this.loadPropertiesFromFile();
        }
    }

    private void loadPropertiesFromFile() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.propertiesFile);
            this.loadProperties(in);
        }
        catch (IOException e) {
            this.exists = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void loadProperties(InputStream in) {
        try {
            this.fillPropertiesTable(new PropertyResourceBundle(in));
            this.exists = true;
        }
        catch (Exception ex) {
            this.exists = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void write() throws IOException {
        if (this.propertiesFile == null) {
            this.write(new File(""), true);
        } else {
            this.write(true);
        }
    }

    public void write(boolean appendLocaleSettings) throws IOException {
        if (this.propertiesFile == null) {
            this.write(new File(""), appendLocaleSettings);
        } else {
            this.write(this.propertiesFile.getParentFile(), appendLocaleSettings);
        }
    }

    public void write(File pathToSave) throws IOException {
        this.write(pathToSave, true);
    }

    public void write(File pathToSave, boolean appendLocaleSettings) throws IOException {
        if (this.propertiesFile == null) {
            StringBuffer filename = new StringBuffer(256);
            filename.append(this.name.replace('.', '/'));
            if (appendLocaleSettings) {
                filename.append('_' + this.locale.getDisplayName());
            }
            filename.append(this.extension);
            this.propertiesFile = new File(pathToSave, filename.toString());
        }
        this.save();
    }

    public long getLastModified() {
        long lastModified = this.propertiesFile == null ? -1L : this.propertiesFile.lastModified();
        return lastModified;
    }

    public void setLastModified(long lastModified) {
        if (this.propertiesFile != null) {
            this.propertiesFile.setLastModified(lastModified);
        }
    }

    private void save() throws IOException {
        if (this.propertiesFile.exists()) {
            this.propertiesFile.delete();
        } else if (!this.propertiesFile.getParentFile().exists()) {
            this.propertiesFile.getParentFile().mkdirs();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.propertiesFile);
            this.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                }
                catch (Exception exception) {}
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void fillPropertiesTable(ResourceBundle properties) {
        Enumeration<String> keys = properties.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.put(key, properties.getObject(key));
        }
    }
}

