/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.io;

import ch.e2e.io.FileUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class Base64Tools {
    public static File encodeToFile(File data) throws IOException {
        return Base64Tools.encodeToFile(data, false);
    }

    public static File encodeToFileChunked(File data) throws IOException {
        return Base64Tools.encodeToFile(data, true);
    }

    public static File encodeToFile(File data, boolean chunked) throws IOException {
        File result = File.createTempFile("base64-", null);
        result.deleteOnExit();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        FileUtilities.copy(new FileInputStream(data), bytesOut);
        FileUtilities.copy(new ByteArrayInputStream(Base64.encodeBase64((byte[])bytesOut.toByteArray(), (boolean)chunked)), new FileOutputStream(result));
        return result;
    }

    public static String encodeToString(byte[] data, boolean chunked) {
        return new String(Base64.encodeBase64((byte[])data, (boolean)chunked));
    }

    public static String encodeToString(String data, boolean chunked) {
        return Base64Tools.encodeToString(data.getBytes(), chunked);
    }

    public static String encodeToString(byte[] data) {
        return Base64Tools.encodeToString(data, false);
    }

    public static String encodeToString(String data) {
        return Base64Tools.encodeToString(data, false);
    }

    public static String encodeToStringChunked(byte[] data) {
        return Base64Tools.encodeToString(data, true);
    }

    public static String encodeToStringChunked(String data) {
        return Base64Tools.encodeToString(data, true);
    }

    public static File decodeToFile(File data) throws IOException {
        File result = File.createTempFile("base64-", null);
        result.deleteOnExit();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        FileUtilities.copy(new FileInputStream(data), bytesOut);
        FileUtilities.copy(new ByteArrayInputStream(Base64.decodeBase64((byte[])bytesOut.toByteArray())), new FileOutputStream(result));
        return result;
    }

    public static void decodeToFile(String data, File decodedData) throws IOException {
        FileUtilities.copy(new ByteArrayInputStream(Base64.decodeBase64((byte[])data.getBytes())), new FileOutputStream(decodedData));
    }

    public static String decodeToString(String data) {
        return new String(Base64.decodeBase64((byte[])data.getBytes()));
    }

    public static byte[] decodeToBytes(String data) {
        return Base64.decodeBase64((byte[])data.getBytes());
    }
}

