/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.tools;

import ch.e2e.secure.TrustAllManager;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ClientFactory {
    public static Client createSimpleTrustingClient() {
        return ClientFactory.createClient(true, new Class[0]);
    }

    public static Client createClient(boolean useTrusting) {
        return ClientFactory.createClient(useTrusting, JacksonFeature.class, MultiPartFeature.class);
    }

    public static Client createClient(boolean useTrusting, Class<?> ... componentClasses) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        Arrays.stream(componentClasses).forEach(arg_0 -> ((ClientBuilder)builder).register(arg_0));
        if (useTrusting) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, new TrustManager[]{new TrustAllManager()}, null);
                builder.sslContext(sslContext).hostnameVerifier((hostname, session) -> true);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return builder.build();
    }
}

