/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderErrorHandler;
import ch.e2e.builder.base.error.BuilderException;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.ErrorLogService;
import ch.e2e.builder.base.error.ParserError;
import ch.e2e.builder.base.error.ParserFatalError;
import ch.e2e.builder.base.error.ParserWarning;
import ch.e2e.builder.base.message.SendFatalErrorEvent;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public abstract class AbstractErrorHandler
implements BuilderErrorHandler {
    private int errorType = 0;
    private int errorAndWarningCount = 0;
    private List<AbstractBuilderError> errors = new ArrayList<AbstractBuilderError>();
    private List<BuilderWarning> warnings = new ArrayList<BuilderWarning>();
    private List<BuilderFatalError> fatalErrors = new ArrayList<BuilderFatalError>();
    private boolean errorsCleared = false;
    private File logfile;

    protected AbstractErrorHandler() {
        this.errorType = 0;
    }

    protected AbstractErrorHandler(File logfile) {
        this.logfile = logfile;
        if (logfile.exists()) {
            this.errorType = 1;
            ErrorLogService.readErrorsAndWarnings(this);
        } else {
            this.errorType = 0;
        }
    }

    public File getLogfile() {
        return this.logfile;
    }

    public void resetErrorsCleared() {
        this.errorsCleared = false;
    }

    public int getErrorType() {
        if (this.errorType == 0 && this.logfile.exists()) {
            this.errorType = 1;
        } else if (this.errorType == 1 && !this.logfile.exists()) {
            this.errorType = 0;
        }
        return this.errorType;
    }

    public boolean hasErrors() {
        return this.errorType > 2;
    }

    @Override
    public boolean hasFatalErrors() {
        return (this.errorType & 8) > 0;
    }

    @Override
    public int getErrorCount() {
        return this.errors.size() + this.fatalErrors.size();
    }

    @Override
    public int getWarningCount() {
        return this.warnings.size();
    }

    @Override
    public int getErrorAndWarningCount() {
        return this.errorAndWarningCount;
    }

    public Object getError(int index) {
        Object error = index < this.fatalErrors.size() ? this.fatalErrors.get(index) : ((index -= this.fatalErrors.size()) < this.errors.size() ? this.errors.get(index) : ((index -= this.errors.size()) < this.warnings.size() ? this.warnings.get(index) : ""));
        return error;
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    public void clear(boolean forced) {
        this.clear(forced, true);
    }

    public void clear(boolean forced, boolean deleteLogfile) {
        if (!this.errorsCleared || forced) {
            File logfile = this.getLogfile();
            if (logfile != null && deleteLogfile) {
                logfile.delete();
            }
            this.errorAndWarningCount = 0;
            this.warnings.clear();
            this.errors.clear();
            this.fatalErrors.clear();
            this.errorAndWarningCount = 0;
            this.errorType = 0;
            this.errorsCleared = true;
        }
    }

    @Override
    public List<BuilderError> getAllErrorsAndWarnings() {
        ArrayList<BuilderError> allErrorsAndWarnings = new ArrayList<BuilderError>();
        if (this.warnings != null) {
            allErrorsAndWarnings.addAll(this.warnings);
            allErrorsAndWarnings.addAll(this.errors);
            allErrorsAndWarnings.addAll(this.fatalErrors);
        }
        return allErrorsAndWarnings;
    }

    public List<AbstractBuilderError> getErrors() {
        return this.errors;
    }

    public List<BuilderFatalError> getFatalErrors() {
        return this.fatalErrors;
    }

    public List<BuilderWarning> getWarnings() {
        return this.warnings;
    }

    public void serialize(boolean writeEmptyFiles) {
        File logfile = this.getLogfile();
        if (logfile != null) {
            if (this.getErrorAndWarningCount() > 0 || writeEmptyFiles) {
                this.writeLogfile();
            } else {
                logfile.delete();
            }
        }
    }

    public void dump() {
        Document errorDoc = this.createErrorDocument();
        try {
            DomUtilities.serialize((OutputStream)System.out, (Document)errorDoc, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public BuilderError error(Throwable exception) {
        return this.addError(new BuilderException(exception));
    }

    @Override
    public BuilderError error(AbstractBuilderError error) {
        return this.addError(error);
    }

    @Override
    public BuilderWarning warning(BuilderWarning warning) {
        return this.addWarning(warning);
    }

    @Override
    public BuilderFatalError fatalError(BuilderFatalError fatalError) {
        return this.addFatalError(fatalError);
    }

    @Override
    public void error(SAXParseException exception) {
        this.addError(new ParserError(exception));
    }

    @Override
    public void warning(SAXParseException exception) {
        this.addWarning(new ParserWarning(exception));
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.addFatalError(new ParserFatalError(exception));
    }

    protected void readLogfileExtensions(Document document) {
    }

    public void removeError(BuilderError error) {
        boolean removed = error instanceof BuilderWarning ? this.warnings.remove(error) : (error instanceof BuilderFatalError ? this.fatalErrors.remove(error) : this.errors.remove(error));
        if (removed) {
            --this.errorAndWarningCount;
            if (this.errorAndWarningCount == 0) {
                this.errorType = 1;
            }
        }
    }

    protected BuilderWarning addWarning(BuilderWarning warning) {
        BuilderWarning result = null;
        if (!this.warnings.contains(warning)) {
            this.warnings.add(warning);
            this.errorType &= 0xE;
            this.errorType |= 2;
            ++this.errorAndWarningCount;
            result = warning;
        }
        return result;
    }

    protected BuilderError addError(AbstractBuilderError error) {
        AbstractBuilderError result = null;
        if (!this.errors.contains(error)) {
            this.errors.add(error);
            this.errorType &= 0xE;
            this.errorType |= 4;
            ++this.errorAndWarningCount;
            result = error;
        }
        return result;
    }

    protected BuilderFatalError addFatalError(BuilderFatalError fatalError) {
        BuilderFatalError result = null;
        if (!this.fatalErrors.contains(fatalError)) {
            this.fatalErrors.add(fatalError);
            this.errorType &= 0xE;
            this.errorType |= 8;
            ++this.errorAndWarningCount;
            result = fatalError;
        }
        return result;
    }

    protected void evaluateErrorAndWarningCount() {
        this.errorAndWarningCount = this.errors.size() + this.fatalErrors.size() + this.warnings.size();
        int n = this.errorType = this.logfile.exists() ? 1 : 0;
        if (this.errors.size() > 0) {
            this.errorType |= 4;
        } else if (this.fatalErrors.size() > 0) {
            this.errorType |= 8;
        } else if (this.warnings.size() > 0) {
            this.errorType |= 2;
        }
    }

    void clearErrors() {
        this.errors.clear();
        this.fatalErrors.clear();
        this.warnings.clear();
        this.errorType = 1;
    }

    public void addTo(AbstractErrorHandler errorHandler) {
        int i;
        int length = this.warnings.size();
        for (i = 0; i < length; ++i) {
            BuilderWarning warning = this.warnings.get(i);
            if (errorHandler.warnings.contains(warning)) continue;
            errorHandler.addWarning(warning);
        }
        length = this.errors.size();
        for (i = 0; i < length; ++i) {
            AbstractBuilderError error = this.errors.get(i);
            if (errorHandler.errors.contains(error)) continue;
            errorHandler.addError(error);
        }
        length = this.fatalErrors.size();
        for (i = 0; i < length; ++i) {
            BuilderFatalError fatalError = this.fatalErrors.get(i);
            if (errorHandler.fatalErrors.contains(fatalError)) continue;
            errorHandler.addFatalError(fatalError);
        }
    }

    private void writeLogfile() {
        File logfile = this.getLogfile();
        Document errorDoc = this.createErrorDocument();
        if (!logfile.getParentFile().exists()) {
            logfile.getParentFile().mkdirs();
        }
        try {
            DomUtilities.serialize((File)logfile, (Document)errorDoc, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception ex) {
            SendFatalErrorEvent event = new SendFatalErrorEvent(logfile, ex.getMessage());
            EventController.fire((EventObject)event);
        }
    }

    protected Document createErrorDocument() {
        Document errorDoc = DomUtilities.newDocument((String)"Errorlist");
        Element root = errorDoc.getDocumentElement();
        List<BuilderError> allErrorsAndWarnings = this.getAllErrorsAndWarnings();
        for (BuilderError error : allErrorsAndWarnings) {
            if (!(error instanceof AbstractBuilderError)) continue;
            root.appendChild(((AbstractBuilderError)error).toNode(errorDoc));
        }
        return errorDoc;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof AbstractErrorHandler) {
            equals = this.logfile.equals(((AbstractErrorHandler)obj).logfile);
        }
        return equals;
    }

    public int hashCode() {
        return this.logfile.hashCode();
    }
}

