/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.error;

import ch.e2e.builder.base.error.BuilderError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractBuilderError
implements BuilderError {
    private String code;
    private Map<String, String> parameter;
    private long time;
    private String source = null;

    protected AbstractBuilderError(String code, Map<String, String> parameter) {
        this.parameter = parameter;
        this.code = code;
        this.time = new Date().getTime();
    }

    protected AbstractBuilderError(Element errorElement) {
        this.code = errorElement.getAttribute("code");
        this.source = errorElement.getAttribute("source");
        try {
            this.time = Long.parseLong(errorElement.getAttribute("time"));
        }
        catch (Exception e) {
            this.time = -1L;
        }
        this.readParameter(errorElement);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public Map<String, String> getParameter() {
        return this.parameter;
    }

    protected void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }

    @Override
    public String getTypeCode() {
        return "error.default";
    }

    @Override
    public Map<String, String> getTypeParameter() {
        return new HashMap<String, String>();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public String toString() {
        return this.getCode();
    }

    public Element toNode(Document parent) {
        Element errorElement = parent.createElement("Error");
        errorElement.setAttribute("type", this.getClass().getName());
        errorElement.setAttribute("code", String.valueOf(this.code));
        if (this.source != null && !this.source.equals("")) {
            errorElement.setAttribute("source", this.source);
        }
        if (System.getProperty("ch.e2e.builder.error.timestamp") != null && Boolean.getBoolean("ch.e2e.builder.error.timestamp")) {
            errorElement.setAttribute("time", String.valueOf(this.time));
        }
        if (this.parameter != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String name : this.parameter.keySet()) {
                keys.add(name);
            }
            Collections.sort(keys, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return -o1.compareTo(o2);
                }
            });
            for (String name : keys) {
                Element parameter = parent.createElement("Parameter");
                parameter.setAttribute("name", name);
                parameter.setAttribute("value", this.parameter.get(name));
                errorElement.appendChild(parameter);
            }
        }
        return errorElement;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other instanceof AbstractBuilderError) {
            result = this.equals((AbstractBuilderError)other);
        }
        return result;
    }

    public boolean equals(AbstractBuilderError error) {
        return (this.code == null && error.code == null || this.code != null && this.code.equals(error.code)) && (this.parameter == null || this.parameter.equals(error.parameter));
    }

    public int hashCode() {
        return (this.code + (this.parameter == null ? "no parameter" : this.parameter.toString())).hashCode();
    }

    @Override
    public Object getChild(int index) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    private void readParameter(Element errorElement) {
        this.parameter = new HashMap<String, String>();
        NodeList parameterList = errorElement.getElementsByTagName("Parameter");
        int length = parameterList.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)parameterList.item(i);
            this.parameter.put(parameter.getAttribute("name"), parameter.getAttribute("value"));
        }
    }
}

