/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.template;

import ch.e2e.xuml.substitutor.PlaceholderSubsitutorFactory;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.template.Template;
import ch.e2e.xuml.template.TemplateConstants;
import ch.e2e.xuml.template.TemplateProcessingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class ResourceTemplate
implements Template {
    private final String resourceName;
    private final File targetFile;
    private final ClassLoader classLoader;

    public ResourceTemplate(String resourceName, File targetFile) {
        this(resourceName, targetFile, Thread.currentThread().getContextClassLoader());
    }

    public ResourceTemplate(String resourceName, File targetFile, ClassLoader classLoader) {
        this.resourceName = resourceName;
        this.targetFile = targetFile;
        this.classLoader = classLoader;
    }

    @Override
    public String getName() {
        return this.resourceName;
    }

    protected String getResourceName() {
        return this.resourceName;
    }

    @Override
    public File getTargetFile() {
        return this.targetFile;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public PlaceholderSubstitutor getPlaceholderSubstitutor() {
        return PlaceholderSubsitutorFactory.getDefaultSubstitutor();
    }

    @Override
    public Reader getReader() throws TemplateProcessingException {
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public Writer getWriter() throws TemplateProcessingException {
        this.getTargetFile().getParentFile().mkdirs();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTargetFile()), this.getTargetFileCharset());
        }
        catch (FileNotFoundException e) {
            throw new TemplateProcessingException(e);
        }
    }

    protected Charset getTargetFileCharset() {
        return TemplateConstants.UTF_8_CHARSET;
    }

    public InputStream getInputStream() throws TemplateProcessingException {
        InputStream is = this.getResourceAsStream();
        if (is == null) {
            String msg = "Could not find resource '" + this.getResourceName() + "'!";
            throw new TemplateProcessingException(msg);
        }
        return is;
    }

    protected InputStream getResourceAsStream() {
        return this.classLoader.getResourceAsStream(this.getResourceName());
    }
}

