/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.view;

import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.settings.view.Container;
import ch.e2e.xuml.settings.view.Group;
import ch.e2e.xuml.settings.view.Node;
import ch.e2e.xuml.settings.view.SettingRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Section
extends Container<Node> {
    public Section(Element element, Map<String, ? extends Setting> settings) {
        super(element);
        NodeList children = element.getChildNodes();
        int nNodes = children.getLength();
        for (int i = 0; i < nNodes; ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            String name = ((Element)child).getTagName();
            if ("Override".equals(name)) {
                SettingRow settingRow = new SettingRow((Element)child, settings);
                this.addChild(settingRow);
                continue;
            }
            if ("Group".equals(name)) {
                Group group = new Group((Element)child, settings);
                this.addChild(group);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public Collection<SettingRow> getSettingRows() {
        ArrayList<Object> settingRows = new ArrayList<Object>();
        for (Node node : this.getChildren().values()) {
            if (node instanceof Group) {
                settingRows.addAll(((Group)node).getChildren().values());
                continue;
            }
            if (!(node instanceof SettingRow)) continue;
            settingRows.add((SettingRow)node);
        }
        Collections.sort(settingRows, new SettingRowsSorter());
        return Collections.unmodifiableCollection(settingRows);
    }

    public Collection<Setting> getSettings() {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        for (SettingRow settingRow : this.getSettingRows()) {
            Setting setting = settingRow.getSetting();
            settings.add(setting);
        }
        return Collections.unmodifiableCollection(settings);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    private static class SettingRowsSorter
    implements Comparator<SettingRow> {
        private SettingRowsSorter() {
        }

        @Override
        public int compare(SettingRow o1, SettingRow o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    }
}

