/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.xuml.module.uml;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibrariesHelper;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskSourceSetFactory;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class UmlTaskSourceSetFactory
extends TaskSourceSetFactory {
    @Override
    public Boolean select(String id) {
        return id.endsWith(".uml.compile");
    }

    @Override
    public Set<String> getBeforeSourceSet(SourceManager sourceManager) {
        HashSet<String> result = new HashSet<String>();
        result.add("project.xml");
        return result;
    }

    @Override
    public Set<String> getSourceSet(SourceManager sourceManager) {
        HashSet<String> result = new HashSet<String>();
        XumlProject projectDocument = ((JsonDocumentSource)sourceManager.getSource("project.xml")).getJsonDocument(XumlProject.class);
        result.add("project.xml");
        result.add(Files.uml__PROJECTNAME_configuration_service_xml(projectDocument.getName()));
        result.add(Files.uml__PROJECTNAME_security_xml(projectDocument.getName()));
        result.add("uml/xuml_base.xml");
        result.add("uml/dataModel.xml");
        result.add("uml/aliases.xml");
        result.addAll(LibrariesHelper.getLibrariesNameSet(sourceManager).stream().map(libName -> "uml/imports/" + libName + ".import.xml").collect(Collectors.toSet()));
        try {
            Path projectPath = sourceManager.getProjectFolder().toPath();
            sourceManager.getSourceFilesStream().filter(path -> {
                String s = projectPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), "/");
                return s.endsWith(".library.json") || s.endsWith(".bpmn.json") || s.endsWith(".module.json") || s.endsWith(".api.json");
            }).forEach(path -> {
                String s = projectPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), "/");
                if (s.endsWith(".library.json")) {
                    result.add("uml/imports/" + path.getFileName().toString().replace(".library.json", ".import.xml"));
                } else if (s.endsWith(".bpmn.json")) {
                    result.add("uml/imports/" + path.getFileName().toString().replace(".bpmn.json", ".bpmn.import.xml"));
                    result.add("uml/" + path.getFileName().toString().replace(".bpmn.json", ".bpmn.implementation.xml"));
                    result.add("uml/" + path.getFileName().toString().replace(".bpmn.json", ".bpmn.service.xml"));
                } else if (s.endsWith(".module.json") || s.endsWith(".api.json")) {
                    result.add("uml/" + path.getFileName().toString().replace(".json", ".xml"));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

