/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Logging;
import java.util.ArrayList;
import java.util.Collection;

public class ValueList
extends ArrayList<Object>
implements Logging {
    private Object defaultValue;
    private Class type;
    private boolean restricted;
    private Helpers helpers;

    public ValueList(boolean restricted, Helpers helpers) {
        this(null, null, restricted, helpers);
    }

    public ValueList(Class type, boolean restricted, Helpers helpers) {
        this(type, null, restricted, helpers);
    }

    public ValueList(Class type, Object defaultValue, boolean restricted, Helpers helpers) {
        this.type = type;
        this.defaultValue = defaultValue;
        this.restricted = restricted;
        this.helpers = helpers;
    }

    private ValueList(Class type, Object defaultValue, boolean restricted, Collection<Object> values, Helpers helpers) {
        this(type, defaultValue, restricted, helpers);
        this.addAll(values);
    }

    @Override
    public void add(int index, String value) {
        Object element;
        if (value != null && (element = this.helpers.getElementHelper().createValue(value, this.type)) != null) {
            super.add(index, element);
        }
    }

    @Override
    public boolean add(String value) {
        Object element;
        boolean result = false;
        if (value != null && (element = this.helpers.getElementHelper().createValue(value, this.type)) != null) {
            result = super.add(element);
        }
        return result;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = this.helpers.getElementHelper().createValue(defaultValue, this.type);
    }

    public Object getFirstValue() {
        return this.size() == 0 ? null : this.get(0);
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public ValueList getCopy() {
        return new ValueList(this.type, this.defaultValue, this.restricted, this, this.helpers);
    }
}

