/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Logging;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.PropertyCustomization;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.compiler.uml.ValueList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;

public class PropertyDefinition
implements Logging {
    public static final String SCOPE_MODEL = "model";
    public static final String SCOPE_DIAGRAM = "diagram";
    public static final String PROPERTY_MIN = "min";
    public static final String PROPERTY_MAX = "max";
    public static final String PROPERTY_PATTERN = "pattern";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_ALLWAYSSHOWDEFAULT = "allwaysShowDefault";
    private boolean visible;
    private boolean editable;
    private String name;
    private String group;
    private Class type;
    private BridgeClass bridgeType;
    private Class referenceType;
    private Object emptyValue;
    private Object defaultValue;
    private Number minValue;
    private Number maxValue;
    private Multiplicity multiplicity;
    private String pattern;
    private ValueList values;
    private PropertyCustomization propertyCustomization;
    private int index = Integer.MAX_VALUE;
    private ArrayList<BridgeStereotype> stereotypes;
    private String scope;
    private boolean allwaysShowDefault = false;
    private Comment description;
    private boolean standardUmlProperty = false;

    public PropertyDefinition(String name, Class type, BridgeClass bridgeType) {
        this(name, type);
        this.bridgeType = bridgeType;
    }

    public PropertyDefinition(String name, Class type) {
        this.name = name;
        this.type = type;
        this.visible = true;
        this.editable = true;
        this.stereotypes = new ArrayList();
        this.scope = SCOPE_MODEL;
    }

    public void setCustomization(PropertyCustomization propertyCustomization) {
        this.propertyCustomization = propertyCustomization;
    }

    public PropertyCustomization getCustomization() {
        return this.propertyCustomization;
    }

    public Comment getDescription() {
        return this.description;
    }

    public void setDescription(Comment description) {
        this.description = description;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public ValueList getValues() {
        return this.values;
    }

    public void setValues(ValueList values) {
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public BridgeClass getBridgeType() {
        return this.bridgeType;
    }

    public Object getEmptyValue() {
        return this.emptyValue;
    }

    public void setEmptyValue(Object value) {
        this.emptyValue = value;
    }

    public Object getDefaultValue() {
        Object result = this.values != null ? this.values.getDefaultValue() : this.defaultValue;
        return result;
    }

    public void setDefaultValue(String value) {
        if (value != null && this.type != null) {
            this.defaultValue = this.createValue(value);
        }
    }

    public Object createValue(Object value) {
        Object result = null;
        if (this.type != null) {
            if (UmlElement.class.isAssignableFrom(this.type) && value instanceof String) {
                result = value;
            } else if (this.type.isAssignableFrom(value.getClass())) {
                result = value;
            } else {
                try {
                    Constructor constructor = this.type.getConstructor(String.class);
                    Object[] initargs = new String[]{value.toString()};
                    result = constructor.newInstance(initargs);
                }
                catch (Exception e) {
                    logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
        return result;
    }

    public ValueList getValues(String dependency, Object value) {
        return null;
    }

    public Object getDefaultValue(String dependency, Object value) {
        Object defaultValue = null;
        if (dependency != null && this.propertyCustomization != null) {
            defaultValue = this.propertyCustomization.getDefaultValue(dependency, value);
        }
        return defaultValue;
    }

    public boolean isEditable(String dependency, Object value) {
        return this.propertyCustomization == null || this.propertyCustomization.isPropertyEditable(dependency, value);
    }

    public boolean ignore(String dependency, Object dependencyValue) {
        return this.propertyCustomization != null && this.propertyCustomization.isPropertyIgnored(dependency, dependencyValue);
    }

    public boolean ignore(Iterator<Property> properties) {
        boolean result = false;
        int length = this.getDependencies().size();
        for (int i = 0; i < length && !result; ++i) {
            String dependency = this.getDependencies().get(i);
            while (properties.hasNext() && !result) {
                Property property = properties.next();
                if (!property.getName().equals(dependency)) continue;
                result = this.ignore(dependency, property.getValue());
            }
        }
        return result;
    }

    public ArrayList<String> getDependencies() {
        return this.propertyCustomization == null ? new ArrayList() : this.propertyCustomization.getDependencies();
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Number value) {
        this.minValue = value;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Number value) {
        this.maxValue = value;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isRequired() {
        return this.multiplicity != null && this.multiplicity.isRequired();
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(Multiplicity multiplicity) {
        this.multiplicity = multiplicity;
    }

    public Property createProperty() {
        return new Property(this);
    }

    public boolean isValid(Object value, String dependency, Object dependencyValue) {
        return true;
    }

    public boolean isValidValue(Object value) {
        boolean isValid = false;
        if (value == null && !this.isRequired()) {
            isValid = true;
        } else if (value != null) {
            if (value instanceof Number) {
                isValid = (this.minValue == null || ((Number)value).doubleValue() >= this.minValue.doubleValue()) && (this.maxValue == null || ((Number)value).doubleValue() <= this.maxValue.doubleValue());
            } else if (value instanceof String) {
                if (((String)value).length() > 0 || !this.isRequired()) {
                    isValid = true;
                }
            } else {
                isValid = true;
            }
        }
        return isValid;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index == -1 ? Integer.MAX_VALUE : index;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void addStereotype(BridgeStereotype stereotype) {
        this.stereotypes.add(stereotype);
    }

    public ArrayList<BridgeStereotype> getStereotypes() {
        return this.stereotypes;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isAllwaysShowDefault() {
        return this.allwaysShowDefault;
    }

    public void setAllwaysShowDefault(boolean allwaysShowDefault) {
        this.allwaysShowDefault = allwaysShowDefault;
    }

    public boolean isStandardUmlProperty() {
        return this.standardUmlProperty;
    }

    public void setStandardUmlProperty(boolean standardUmlProperty) {
        this.standardUmlProperty = standardUmlProperty;
    }
}

