/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.PropertyDefinition;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.Collection;
import org.w3c.dom.Element;

public class Property
implements Cloneable {
    private String name;
    private Object value;
    private PropertyDefinition definition;

    public Property(PropertyDefinition definition, Object value) {
        this.definition = definition;
        this.name = definition.getName();
        this.value = value;
    }

    public Property(PropertyDefinition definition) {
        this.definition = definition;
        this.name = definition.getName();
        this.value = definition.getDefaultValue();
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (value instanceof String && this.definition.getType() != null && !this.definition.getType().equals(String.class)) {
            value = this.definition.createValue(value);
        }
        this.value = value;
    }

    public void setDependencyValue(String dependency, Object dependencyValue) {
        if (this.definition.ignore(dependency, dependencyValue)) {
            this.setValue(null);
        } else if (!this.definition.isValid(this.getValue(), dependency, dependencyValue)) {
            this.setValue(this.definition.getDefaultValue(dependency, dependencyValue));
        }
    }

    public boolean isEmpty() {
        return this.value == null || this.getEmptyValue() != null && this.value.equals(this.getEmptyValue()) || this.value.toString().length() == 0;
    }

    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    public Class getType() {
        return this.definition.getType();
    }

    public Object getEmptyValue() {
        return this.definition.getEmptyValue();
    }

    public Object getDefaultValue() {
        return this.definition.getDefaultValue();
    }

    public Number getMinValue() {
        return this.definition.getMinValue();
    }

    public Number getMaxValue() {
        return this.definition.getMaxValue();
    }

    public boolean isRequired() {
        return this.definition.isRequired();
    }

    public boolean isValidValue(Object value) {
        return this.definition.isValidValue(value);
    }

    public boolean isValid() {
        boolean valid = true;
        Object val = this.value instanceof String && ((String)this.value).length() == 0 ? null : this.value;
        if (this.isRequired() || val != null) {
            valid = val != null && this.isValidValue(val);
        }
        return valid;
    }

    public void clearValue() {
        this.value = this.definition.getDefaultValue();
    }

    public void toXmi(Element owner, Collection<Property> properties, Module dataModelModule, XmiIDFactory xmiIDFactory) {
        Object value = this.findVisibleValue(properties);
        if (value != null) {
            if (value instanceof UmlElement) {
                UmlElement umlElement = (UmlElement)value;
                Module elementModule = umlElement.getModule();
                if (this.checkModule(elementModule, dataModelModule)) {
                    owner.setAttribute(this.getName(), umlElement.getXmiID());
                } else {
                    Element child = owner.getOwnerDocument().createElement(this.getName());
                    child.setAttribute("href", elementModule.getName() + '#' + umlElement.getXmiID());
                    child.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + umlElement.getBaseclass());
                    owner.appendChild(child);
                }
            } else {
                owner.setAttribute(this.getName(), value.toString());
            }
        }
    }

    public void toXmi(Element owner, Object value, Module dataModelModule, XmiIDFactory xmiIDFactory) {
        if (value instanceof UmlElement) {
            UmlElement umlElement = (UmlElement)value;
            Module elementModule = umlElement.getModule();
            if (this.checkModule(elementModule, dataModelModule)) {
                owner.setAttribute(this.getName(), umlElement.getXmiID());
            } else {
                Element child = owner.getOwnerDocument().createElement(this.getName());
                child.setAttribute("href", elementModule.getName() + '#' + umlElement.getXmiID());
                child.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + umlElement.getBaseclass());
                owner.appendChild(child);
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                Element child = owner.getOwnerDocument().createElement(this.getName());
                child.appendChild(owner.getOwnerDocument().createTextNode(o.toString()));
                owner.appendChild(child);
            }
        } else {
            owner.setAttribute(this.getName(), value.toString());
        }
    }

    public Object findVisibleValue(Collection<Property> properties) {
        Object value = null;
        if (this.isEmpty() && this.isRequired() && !this.definition.ignore(properties.iterator())) {
            value = this.getDefaultValue();
        } else if (this.isRequired() || this.getValue() != null && !this.getValue().equals(this.getDefaultValue()) || this.definition.isAllwaysShowDefault()) {
            value = this.getValue();
        }
        return value;
    }

    protected Object clone() throws CloneNotSupportedException {
        Property clone = (Property)super.clone();
        if (this.value != null) {
            Object newValue = this.definition.createValue(this.value);
            clone.value = newValue == null ? this.value : newValue;
        }
        return clone;
    }

    private boolean checkModule(Module elementModule, Module dataModelModule) {
        return elementModule == null || elementModule.equals(dataModelModule);
    }
}

