/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.Customization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.PropertyDefinition;
import ch.e2e.builder.compiler.uml.PropertyGroup;
import ch.e2e.builder.compiler.uml.Referenceable;
import ch.e2e.builder.compiler.uml.UmlProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;

public class BridgeStereotype
implements Comparable,
Referenceable {
    private BridgeStereotype generalization;
    private HashMap<String, PropertyDefinition> propertyDefinitions;
    private String name;
    private String description;
    private Customization customization;
    private UmlProperties properties;
    private BridgeStereotype deploymentType;
    private BridgeStereotype classifierType;
    private String xmiID;
    private String ebmId;
    private BridgePackage owningPackage;
    private Object reference;
    private ArrayList<String> baseclasses;
    private Module module;
    private Helpers helpers;

    public BridgeStereotype(String name, String description, Helpers helpers) {
        this.description = description;
        this.name = name;
        this.helpers = helpers;
        this.propertyDefinitions = new LinkedHashMap<String, PropertyDefinition>();
        this.properties = new UmlProperties();
        this.baseclasses = new ArrayList();
        this.customization = new Customization();
    }

    public Helpers getHelpers() {
        return this.helpers;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        Customization cust = this.getCustomization();
        return cust == null ? null : cust.getIcon();
    }

    public Object getReference() {
        return this.reference;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }

    public Object getCustomizationProperty(String name) {
        Object result = null;
        if (this.customization != null && (result = this.customization.getProperty(name)) == null && this.generalization != null) {
            result = this.generalization.getCustomizationProperty(name);
        }
        return result;
    }

    public Customization getCustomization() {
        return this.customization;
    }

    public void setCustomization(Customization customization) {
        this.customization = customization;
    }

    public TreeMap<PropertyGroup, TreeSet<PropertyDefinition>> getPropertyGroupsWithDerived() {
        TreeMap<PropertyGroup, TreeSet<PropertyDefinition>> result = new TreeMap<PropertyGroup, TreeSet<PropertyDefinition>>(Customization.propertyGroupComparator);
        if (this.customization != null) {
            result.putAll(this.customization.getPropertyGroupsMap());
        }
        if (this.generalization != null) {
            TreeMap<PropertyGroup, TreeSet<PropertyDefinition>> groups = this.generalization.getPropertyGroupsWithDerived();
            for (PropertyGroup group : groups.keySet()) {
                TreeSet<PropertyDefinition> properties = result.get(group);
                if (properties == null) {
                    result.put(group, groups.get(group));
                    continue;
                }
                for (PropertyDefinition definition : groups.get(group)) {
                    if (properties.contains(definition)) continue;
                    properties.add(definition);
                }
            }
        }
        return result;
    }

    public BridgeStereotype getClassifierType() {
        return this.classifierType;
    }

    public void setClassifierType(BridgeStereotype classifierType) {
        this.classifierType = classifierType;
        if (classifierType != null && classifierType.getDeploymentType() == null) {
            classifierType.setDeploymentType(this);
        }
    }

    public BridgeStereotype getDeploymentType() {
        return this.deploymentType;
    }

    public void setDeploymentType(BridgeStereotype deploymentType) {
        this.deploymentType = deploymentType;
        if (deploymentType != null && deploymentType.getClassifierType() == null) {
            deploymentType.setClassifierType(this);
        }
    }

    public boolean isRequired() {
        boolean required = false;
        if (this.customization != null && this.customization.getProperty("required") != null) {
            required = (Boolean)this.customization.getProperty("required");
        } else if (this.getDeploymentType() != null && this.getDeploymentType().getCustomization() != null && this.getDeploymentType().getCustomization().getProperty("required") != null) {
            required = (Boolean)this.getDeploymentType().getCustomization().getProperty("required");
        }
        return required;
    }

    public boolean isUsable() {
        boolean usable = true;
        if (this.customization != null && this.customization.getProperty("useable") != null) {
            usable = (Boolean)this.customization.getProperty("useable");
        } else if (this.getDeploymentType() != null && this.getDeploymentType().getCustomization() != null && this.getDeploymentType().getCustomization().getProperty("useable") != null) {
            usable = (Boolean)this.getDeploymentType().getCustomization().getProperty("useable");
        }
        return usable;
    }

    public BridgeStereotype getGeneralization() {
        return this.generalization;
    }

    public void setGeneralization(BridgeStereotype generalization) {
        this.generalization = generalization;
    }

    public boolean isDerivedFrom(BridgeStereotype superStereotype) {
        boolean derivedFrom = false;
        for (BridgeStereotype generalization = this; generalization != null && !derivedFrom; generalization = generalization.getGeneralization()) {
            derivedFrom = generalization.equals(superStereotype);
        }
        return derivedFrom;
    }

    public HashMap<String, PropertyDefinition> getPropertyDefinitions() {
        HashMap<String, PropertyDefinition> result = new HashMap<String, PropertyDefinition>();
        result.putAll(this.propertyDefinitions);
        if (this.generalization != null) {
            result.putAll(this.generalization.getPropertyDefinitions());
        }
        return result;
    }

    public void setPropertyDefinitions(List<PropertyDefinition> propertyDefinitions) {
        for (PropertyDefinition definition : propertyDefinitions) {
            this.propertyDefinitions.put(definition.getName(), definition);
        }
    }

    public void setPropertyDefinitions(HashMap<String, PropertyDefinition> propertyDefinitions) {
        this.propertyDefinitions = propertyDefinitions;
    }

    public UmlProperties getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String name) {
        String result = null;
        if (this.properties.hasProperty(name)) {
            result = (String)((Property)this.properties.get(name)).getValue();
        } else if (this.propertyDefinitions.containsKey(name)) {
            result = (String)this.propertyDefinitions.get(name).createProperty().getValue();
        }
        return result;
    }

    public Property getProperty(String name) {
        PropertyDefinition def;
        Property property = (Property)this.properties.get(name);
        if (property == null && (def = this.propertyDefinitions.get(name)) != null) {
            property = def.createProperty();
        }
        return property;
    }

    public void addProperty(String name, String value) {
        PropertyDefinition propertyDef = new PropertyDefinition(name, String.class);
        Property property = new Property(propertyDef, value);
        this.addProperty(property);
    }

    public void addProperty(Property property) {
        this.properties.addProperty(property);
    }

    public boolean hasArbitraryInputParams() {
        try {
            return (Boolean)this.properties.getProperty("hasArbitraryParameters").getValue();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        return this.name.compareToIgnoreCase(o.toString());
    }

    public String getEbmId() {
        return this.ebmId;
    }

    public void setEbmId(String ebmId) {
        this.ebmId = ebmId;
    }

    public String getXmiID() {
        return this.xmiID;
    }

    public void setXmiID(String xmiID) {
        this.xmiID = xmiID;
    }

    public BridgePackage getOwningPackage() {
        return this.owningPackage;
    }

    public void setOwningPackage(BridgePackage owningPackage) {
        this.owningPackage = owningPackage;
    }

    public void addBaseclass(String baseclass) {
        this.baseclasses.add(baseclass);
    }

    public String getDefaultBaseclass() {
        String baseclass = null;
        if (this.getCustomizationProperty("defaultBaseclass") != null) {
            baseclass = (String)this.getCustomizationProperty("defaultBaseclass");
        }
        if (baseclass == null || !this.containsBaseclass(baseclass)) {
            baseclass = this.baseclasses.size() > 0 ? this.baseclasses.get(0) : null;
        }
        return baseclass;
    }

    public boolean containsBaseclass(String baseclass) {
        return this.baseclasses.contains(baseclass);
    }

    public boolean isDeploymentType() {
        return this.getName().equals("E2EBridgeServerInstance") || this.getName().equals("BackendServerInstance") || this.getName().equals("E2ELibraryServerInstance") || this.getName().equals("E2EProxyServerInstance") || this.getName().equals("E2ELibraryDeployment") || this.generalization != null && (this.generalization.getName().equals("BackendServiceDeployment") || this.generalization.getName().equals("BackendInterfaceDeployment") || this.generalization.getName().equals("E2EDeployableDeployment") || this.generalization.getName().equals("E2EServiceDeployment") || this.generalization.getName().equals("E2EInterfaceDeployment"));
    }

    public boolean isBackendInterfaceType() {
        return this.isDerivedFrom(this.getHelpers().getStereotypeFactory().getStereotype("BackendInterface"));
    }

    public boolean isHideTaggedValues() {
        Boolean hideTaggedValues = (Boolean)this.getCustomization().getProperty("hideTaggedValues");
        return hideTaggedValues != null && hideTaggedValues != false;
    }

    public boolean isCreatable() {
        Boolean creatable = this.classifierType == null ? (Boolean)this.getCustomization().getProperty("creatable") : (Boolean)this.classifierType.getCustomization().getProperty("creatable");
        return creatable == null || creatable != false;
    }

    public boolean isVisible() {
        Boolean visible = this.classifierType == null ? (Boolean)this.getCustomization().getProperty("visible") : (Boolean)this.classifierType.getCustomization().getProperty("visible");
        return visible == null || visible != false;
    }

    public boolean isArchive() {
        boolean archive = false;
        BridgeStereotype archiveType = this.getHelpers().getStereotypeFactory().getStereotype("ArchiveFile");
        for (BridgeStereotype type = this; !archive && type != null; type = type.getGeneralization()) {
            archive = type.equals(archiveType);
        }
        return archive;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BridgeStereotype)) {
            return false;
        }
        BridgeStereotype stereotype = (BridgeStereotype)o;
        return stereotype.getName().equals(this.getName()) && (stereotype.getXmiID() == null || stereotype.getXmiID().equals(this.getXmiID()));
    }
}

