/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.library;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.library.Library;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class LibraryRegistry {
    private HashMap<String, Library> libraries = new HashMap();
    private Helpers helpers;

    public LibraryRegistry(Helpers helpers) {
        this.helpers = helpers;
    }

    public void reset() {
        File[] existingLibs;
        this.libraries.clear();
        File libsFolder = new File(E2EBuilderProject.getProjectFolderName(), "libs");
        for (File file : existingLibs = FileUtilities.getFileList((File)libsFolder, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".lrep");
            }
        })) {
            try {
                Library library = new Library(file, new File(E2EBuilderProject.getProjectFolderName(), "imports/"), this.helpers);
                this.libraries.put(library.getName(), library);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Collection<Library> getLibraries() {
        return this.libraries.values();
    }

    public Library getExistingLibrary(String name) {
        return this.libraries.get(name);
    }

    public ArrayList<Library> getLibrariesUsingLibrary(String library) {
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library existingLib : this.libraries.values()) {
            if (!existingLib.containsImport(library)) continue;
            result.add(existingLib);
        }
        return result;
    }
}

