/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.json.xuml;

import ch.e2e.builder.compiler.document.json.xuml.XumlDocument;
import ch.e2e.builder.compiler.document.json.xuml.XumlElement;
import ch.e2e.builder.compiler.document.json.xuml.project.XumlApplication;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="project", namespace="http://scheer-group.com/xuml")
public class XumlProject
extends XumlElement
implements XumlDocument {
    public static final String DEPLOYMENT_TYPE_bridge = "bridge";
    public static final String DEPLOYMENT_TYPE_docker = "docker";
    private static final String[] ENVIRONMENTS = new String[]{"production", "dev"};
    private static final String[] DEPLOYMENT_TYPES = new String[]{"bridge", "docker"};
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String description;
    @XmlAttribute
    private String version;
    @XmlAttribute
    private String category;
    @XmlAttribute
    private Integer servicePort;
    @XmlAttribute
    private Integer controlPort;
    @XmlAttribute
    private Integer proxyPort;
    private String environment = ENVIRONMENTS[0];
    private XumlApplication application = new XumlApplication();
    private String deploymentType = DEPLOYMENT_TYPES[0];
    @XmlAttribute
    private String hostname;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Integer getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(Integer servicePort) {
        this.servicePort = servicePort;
    }

    public Integer getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(Integer controlPort) {
        this.controlPort = controlPort;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getEnvironment() {
        if (Boolean.getBoolean("ch.e2e.builder.development")) {
            return ENVIRONMENTS[1];
        }
        return Stream.of(ENVIRONMENTS).filter(env -> env.equalsIgnoreCase(this.environment)).findFirst().orElse(ENVIRONMENTS[0]);
    }

    @XmlAttribute
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public XumlApplication getApplication() {
        if (this.application == null) {
            this.application = new XumlApplication();
        }
        return this.application;
    }

    public void setApplication(XumlApplication application) {
        this.application = application;
    }

    public String getDeploymentType() {
        return Stream.of(DEPLOYMENT_TYPES).filter(env -> env.equalsIgnoreCase(this.deploymentType)).findFirst().orElse(DEPLOYMENT_TYPES[0]);
    }

    @XmlAttribute
    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }
}

