/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.error.ModelError;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmiTransformationModelHelper {
    public static void replaceIdRefs(Element model, HashMap<Module, ArrayList<String>> modelIds) throws XPathExpressionException {
        List idNodes = DomUtilities.selectNodes((Node)model, (String)"*//@xmi:idref");
        for (Node node : idNodes) {
            String id = ((Attr)node).getValue();
            Element parent = ((Attr)node).getOwnerElement();
            if (parent == null) continue;
            if (!id.contains("#")) {
                for (Module module : modelIds.keySet()) {
                    ArrayList<String> ids = modelIds.get(module);
                    if (!ids.contains(id)) continue;
                    parent.removeAttribute(((Attr)node).getName());
                    parent.setAttribute("href", module.getName() + '#' + id);
                }
                continue;
            }
            parent.removeAttribute(((Attr)node).getName());
            parent.setAttribute("href", id);
        }
    }

    public static String parentNodeXumlIdAttribute(Node initialNode) {
        for (Node parentNode = initialNode.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            Node xumlId = parentNode.getAttributes().getNamedItemNS("http://scheer-group.com/xuml", "id");
            if (xumlId == null) continue;
            return ((Attr)xumlId).getValue();
        }
        return null;
    }

    public static Set<Module> replaceXumlIdRefs(Element model, String moduleName, HashMap<String, IDLSource> idlSources, AbstractErrorHandler errorHandler) throws XPathExpressionException {
        HashSet<Module> modules = new HashSet<Module>();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xuml", "http://scheer-group.com/xuml");
        List idNodes = DomUtilities.selectNodes((Node)model, (String)"*//@xuml:idref", namespaces);
        for (Node node : idNodes) {
            String id = ((Attr)node).getValue();
            Element parent = ((Attr)node).getOwnerElement();
            if (parent == null) continue;
            parent.removeAttribute(((Attr)node).getName());
            if (id.startsWith("Bridge Base#")) {
                parent.setAttribute("href", id.replace("Bridge Base#", "E2E Bridge Base.xml#"));
                continue;
            }
            if (id.startsWith("E2E Bridge Base.xml")) {
                parent.setAttribute("href", id);
                continue;
            }
            if (!id.contains("#")) {
                parent.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", id);
                continue;
            }
            String localId = id.substring(id.indexOf("#") + 1);
            String file = id.substring(0, id.indexOf("#"));
            String targetModuleName = "";
            if (file.startsWith("libs/")) {
                String libraryName = file.substring("libs/".length(), file.length() - ".library.json".length());
                IDLSource idlSource = idlSources.get(libraryName);
                if (idlSource != null) {
                    UmlElement umlElement = idlSource.getIDLImportSource().getElementMaps().allReferableElements.get(localId);
                    if (umlElement != null) {
                        Module module = umlElement.getModule();
                        modules.add(module);
                        targetModuleName = module.getName();
                        localId = umlElement.getXmiID();
                    } else {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        parameters.put("library.name", libraryName);
                        parameters.put("type.id", id);
                        errorHandler.error((AbstractBuilderError)new ModelError("ELIB0002", parameters, XmiTransformationModelHelper.parentNodeXumlIdAttribute(parent)));
                    }
                } else {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("library.name", libraryName);
                    errorHandler.error((AbstractBuilderError)new ModelError("ELIB0001", parameters, XmiTransformationModelHelper.parentNodeXumlIdAttribute(parent)));
                }
            } else if (file.startsWith("dataModel/")) {
                targetModuleName = "dataModel.xml";
            }
            if (id.startsWith("#") || targetModuleName.equals("") || targetModuleName.equals(moduleName)) {
                parent.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:idref", localId);
                continue;
            }
            parent.setAttribute("href", targetModuleName + '#' + localId);
        }
        return modules;
    }
}

