/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document;

import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.compiler.descriptor.BPMNDiagram;
import ch.e2e.builder.compiler.descriptor.Composite;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.Library;
import ch.e2e.builder.compiler.descriptor.RepositoryDescriptor;
import ch.e2e.builder.compiler.document.DependsFile;
import ch.e2e.builder.compiler.document.DocumentInfo;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.Logging;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.error.DocumentErrorHandler;
import ch.e2e.builder.compiler.error.EXMIErrorHandler;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.TreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UmlDocument
implements Logging,
TreeObject {
    private RepositoryDescriptor descriptor;
    private File umlFile;
    private String name;
    private String documentName;
    private String displayName;
    private DocumentErrorHandler errorHandler;
    private EXMIErrorHandler exmiErrors;
    private long lastModified;
    private String uniqueId;
    private File bridgeXmiFile;
    private File bridgeXmiWithImportsFile;
    private File descriptorFile;
    private File documentWorkingFolder;
    private boolean descriptorIncluded;
    private DocumentInfo documentInfo;
    private ArrayList<BPMNDiagram> bpmnDiagrams;
    private UmlDocumentFactory umlDocumentFactory;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public UmlDocument(File umlFile, String uniqueId, UmlDocumentFactory umlDocumentFactory) {
        this.umlFile = umlFile;
        this.umlDocumentFactory = umlDocumentFactory;
        this.uniqueId = uniqueId;
        this.setName();
        this.bpmnDiagrams = new ArrayList();
        this.documentWorkingFolder = new File(this.getSettings().getWorkFolder(), uniqueId);
        this.documentInfo = new DocumentInfo(this.documentWorkingFolder);
        String filename = uniqueId + ".bxmi";
        this.bridgeXmiFile = new File(this.documentWorkingFolder, filename);
        filename = uniqueId + ".bxmi.wi";
        this.bridgeXmiWithImportsFile = new File(this.documentWorkingFolder, filename);
        File descriptorFolder = new File(this.documentWorkingFolder, "descriptor");
        this.descriptorFile = new File(descriptorFolder, "descriptor.xml");
        if (this.bridgeXmiFile.exists()) {
            try {
                this.setDescriptorIncluded(UmlDocument.isDescriptorIncluded(DomUtilities.parse((File)this.bridgeXmiFile, (boolean)false, (boolean)false, (boolean)false)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.descriptorFile.exists()) {
            try {
                this.setDescriptorDocument(DomUtilities.parse((File)this.descriptorFile, (boolean)false, (boolean)false, (boolean)false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.lastModified = umlFile.lastModified();
    }

    public File getDocumentWorkingFolder() {
        if (!this.documentWorkingFolder.exists()) {
            this.documentWorkingFolder.mkdirs();
        }
        return this.documentWorkingFolder;
    }

    public UmlDocumentCompilerSettings getSettings() {
        return this.umlDocumentFactory.getSettings();
    }

    public UmlDocumentFactory getUmlDocumentFactory() {
        return this.umlDocumentFactory;
    }

    public boolean hasChanged() {
        return this.umlFile.lastModified() != this.lastModified;
    }

    public void resetLastModified() {
        this.lastModified = this.umlFile.lastModified();
    }

    public long lastModified() {
        return this.umlFile.lastModified();
    }

    public File getBridgeXmiFile() {
        return this.bridgeXmiFile;
    }

    public File getBridgeXmiWithImportsFile() {
        return this.bridgeXmiWithImportsFile;
    }

    public File getOriginalFile() {
        return this.umlFile;
    }

    public File getDescriptorFile() {
        return this.descriptorFile;
    }

    public String getAbsolutePath() {
        return FileUtilities.getAbsolutePath((File)this.umlFile);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.documentName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void renameTo(String name) {
        if (!name.endsWith(".xml")) {
            name = name + ".xml";
        }
    }

    public boolean hasDescriptor() {
        this.readDescriptorDocument();
        return this.descriptor != null && !this.descriptor.isEmpty();
    }

    public RepositoryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Iterator<Deployment> getDeploymentIterator() {
        return this.descriptor == null ? EMPTY_ITERATOR : this.descriptor.getDeploymentIterator();
    }

    public Iterator<Deployment> getRunningDeploymentIterator() {
        return this.descriptor == null ? EMPTY_ITERATOR : this.descriptor.getRunningDeploymentIterator();
    }

    public void setDescriptorDocument(Document descriptorDocument) {
        if (descriptorDocument != null) {
            if (this.descriptor == null) {
                this.descriptor = new RepositoryDescriptor(this, descriptorDocument);
            } else {
                this.descriptor.reset(descriptorDocument);
            }
            for (Composite composite : this.descriptor.getComposites()) {
                this.getErrorHandler().addTo(composite.getErrorHandler());
            }
            for (Library library : this.descriptor.getLibraries()) {
                this.getErrorHandler().addTo(library.getErrorHandler());
            }
            this.bpmnDiagrams.clear();
            NodeList bpmnDiagrams = descriptorDocument.getElementsByTagName("BPMNDiagram");
            int length = bpmnDiagrams.getLength();
            for (int i = 0; i < length; ++i) {
                Element diagram = (Element)bpmnDiagrams.item(i);
                this.bpmnDiagrams.add(new BPMNDiagram(diagram, this));
            }
        }
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public boolean delete() {
        File mdrFile;
        File bakFile = new File(this.umlFile.getParentFile(), this.umlFile.getName() + ".bak");
        if (bakFile.exists()) {
            bakFile.delete();
        }
        if ((mdrFile = new File(this.umlFile.getParentFile(), this.umlFile.getName() + ".mdr")).exists()) {
            mdrFile.delete();
        }
        return this.umlFile.delete();
    }

    public boolean isActive() {
        return this.documentName != null;
    }

    public void clearAll() {
        this.clear(false);
        this.name = null;
        this.documentName = null;
        this.displayName = null;
        this.errorHandler = null;
        this.descriptor = null;
    }

    public void clear() {
        this.clear(true);
    }

    public void clearAllErrors() {
        if (this.getErrorHandler() != null) {
            this.getErrorHandler().clear(true, true);
        }
        if (this.getEXMIErrorHandler() != null) {
            this.getEXMIErrorHandler().clear(true, true);
        }
        if (this.descriptor != null) {
            for (Composite composite : this.descriptor.getComposites()) {
                composite.getErrorHandler().clear(true, true);
            }
            for (Library library : this.descriptor.getLibraries()) {
                library.getErrorHandler().clear(true, true);
            }
        }
    }

    public DocumentInfo getDocumentInfo() {
        return this.documentInfo;
    }

    public ArrayList<UmlDocument> getAllUmlDocuments() {
        ArrayList<UmlDocument> allUmlDocuments = new ArrayList<UmlDocument>();
        this.readSources(this, allUmlDocuments);
        return allUmlDocuments;
    }

    private void readSources(UmlDocument umlDocument, ArrayList<UmlDocument> allUmlDocuments) {
        if (!allUmlDocuments.contains(umlDocument)) {
            allUmlDocuments.add(umlDocument);
            DependsFile dependsFile = umlDocument.getDocumentInfo().getDependsFile();
            for (IncludesFile includesFile : dependsFile.getIncludesFiles().values()) {
                UmlDocument importedDocument = umlDocument.getUmlDocumentFactory().getUmlDocumentById(includesFile.getUmlFileID());
                if (importedDocument == null) continue;
                this.readSources(importedDocument, allUmlDocuments);
            }
        }
    }

    private void clear(boolean deleteErrorLog) {
        if (this.getErrorHandler() != null) {
            this.getErrorHandler().clear(false, deleteErrorLog);
        }
        if (this.getEXMIErrorHandler() != null) {
            this.getEXMIErrorHandler().clear(false, deleteErrorLog);
        }
        if (this.descriptor != null) {
            this.descriptor.clear(deleteErrorLog);
        }
    }

    public boolean exists() {
        return this.umlFile != null && this.umlFile.exists();
    }

    public boolean canBuild() {
        return this.getBridgeXmiFile().exists();
    }

    protected void rename(String filename) {
        this.umlFile.renameTo(new File(this.umlFile.getParentFile(), filename));
        this.setName(filename, "");
    }

    protected void setName() {
        this.setName(this.umlFile.getName(), "");
    }

    protected void setName(String documentName, String extension) {
        String relativePath;
        String lowerName = documentName.toLowerCase();
        this.documentName = lowerName.endsWith(".xml") || lowerName.endsWith(".xmi") ? documentName.substring(0, lowerName.length() - 4).trim() : documentName.trim();
        this.displayName = this.documentName + extension;
        if (this.umlFile.getParentFile() == null) {
            relativePath = "";
        } else {
            relativePath = FileUtilities.getRelativePath((File)this.umlFile.getParentFile(), (File)this.getSettings().getUmlSourceFolder());
            relativePath = relativePath.replace('\\', '/');
        }
        if (relativePath.length() > 0 && !relativePath.endsWith("/")) {
            relativePath = relativePath + "/";
        }
        this.documentName = relativePath + this.documentName;
        this.name = relativePath + documentName;
    }

    public int getErrorCount() {
        return this.getEXMIErrorHandler().getErrorCount() + this.getErrorHandler().getErrorCount();
    }

    public int getWarningCount() {
        return this.getEXMIErrorHandler().getWarningCount() + this.getErrorHandler().getWarningCount();
    }

    public int getErrorAndWarningCount() {
        return this.getEXMIErrorHandler().getErrorAndWarningCount() + this.getErrorHandler().getErrorAndWarningCount();
    }

    public Object getError(int index) {
        Object result = index < this.getEXMIErrorHandler().getErrorAndWarningCount() ? this.getEXMIErrorHandler().getError(index) : this.getErrorHandler().getError(index);
        return result;
    }

    public List<BuilderError> getAllErrorsAndWarnings() {
        return this.getErrorHandler().getAllErrorsAndWarnings();
    }

    public DocumentErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new DocumentErrorHandler(this);
        }
        return this.errorHandler;
    }

    public EXMIErrorHandler getEXMIErrorHandler() {
        if (this.exmiErrors == null) {
            this.exmiErrors = new EXMIErrorHandler(this);
        }
        return this.exmiErrors;
    }

    public void serializeErrors(boolean writeEmptyFiles) {
        this.getErrorHandler().serialize(writeEmptyFiles);
        this.getEXMIErrorHandler().serialize(writeEmptyFiles);
    }

    public int getErrorType() {
        if (this.getEXMIErrorHandler().getErrorType() >= 2) {
            return Math.max(this.getErrorHandler().getErrorType(), this.getEXMIErrorHandler().getErrorType());
        }
        return this.getErrorHandler().getErrorType();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void readDescriptorDocument() {
        if (this.descriptor == null && this.descriptorFile.exists()) {
            try {
                this.setDescriptorDocument(DomUtilities.parse((File)this.descriptorFile, (boolean)false, (boolean)false));
            }
            catch (Exception e) {
                logger.finest(e.getMessage());
                logger.throwing(this.getClass().getName(), "readDescriptorDocument", e);
            }
        }
    }

    public static boolean isDescriptorIncluded(Document bridgeXmiDocument) {
        return DomUtilities.getBoolean((Element)bridgeXmiDocument.getDocumentElement(), (String)"descriptor", (boolean)false) || DomUtilities.getBoolean((Element)bridgeXmiDocument.getDocumentElement(), (String)"BPMNDiagram", (boolean)false);
    }

    public void setDescriptorIncluded(boolean descriptorIncluded) {
        this.descriptorIncluded = descriptorIncluded;
        if (!descriptorIncluded) {
            if (this.descriptor != null) {
                this.descriptor.clear(true);
                this.descriptor = null;
            }
            this.descriptorFile.delete();
        }
    }

    public boolean isDescriptorIncluded() {
        return this.descriptorIncluded;
    }

    public ArrayList<BPMNDiagram> getBPMNDiagrams() {
        return this.bpmnDiagrams;
    }

    public void setBPMNDiagrams(ArrayList<BPMNDiagram> bpmnDiagrams) {
        this.bpmnDiagrams = bpmnDiagrams;
    }

    public int getType() {
        return this.getTreeType(6);
    }

    protected int getTreeType(int offset) {
        int errorType = this.getErrorType();
        int result = (errorType & 8) != 0 ? offset + 4 : ((errorType & 4) != 0 ? offset + 3 : ((errorType & 2) != 0 ? offset + 2 : offset + errorType));
        return result;
    }

    public Object getChild(int index) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public boolean isLeaf() {
        return false;
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof UmlDocument && this.getUniqueId().equals(((UmlDocument)obj).getUniqueId());
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    private static class EmptyIterator
    implements Iterator<Deployment> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Deployment next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

