/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.crontab;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.addons.crontab.Event;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseTabfile
extends XmlTabfile {
    private Map<String, Event> eventDefinitions = new TreeMap<String, Event>();
    private Set<String> stubs = new HashSet<String>();
    private boolean library = false;

    public BaseTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    protected static Iterator<Element> getElementIteratorByXPath(Element tabfileElement, String xpath) {
        NodeList nodes = DomUtilities.EMPTY_NODE_LIST;
        try {
            nodes = (NodeList)DomUtilities.evaluate((Node)tabfileElement, (String)xpath, (QName)XPathConstants.NODESET);
            return nodes;
        }
        finally {
            return DomUtilities.elementIterator((NodeList)nodes);
        }
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        if (!library) {
            Iterator<Map.Entry<String, Event>> it = this.eventDefinitions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Event> entry = it.next();
                if (this.stubs.contains(entry.getKey())) continue;
                for (String var : entry.getValue().getVariables()) {
                    substitutions.removeVariableFromTemplate(var, this.getName());
                }
                it.remove();
            }
        }
        this.library = library;
        super.doMergePostProcess(substitutions, library);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator<Element> definitionIterator = BaseTabfile.getElementIteratorByXPath(replaced, "Event[@awaitingDefinition eq 'false']");
        while (definitionIterator.hasNext()) {
            this.addDefinition(definitionIterator.next());
        }
        Iterator<Element> stubIterator = BaseTabfile.getElementIteratorByXPath(replaced, "Event[@awaitingDefinition eq 'true']");
        while (stubIterator.hasNext()) {
            this.stubs.add(stubIterator.next().getAttribute("id"));
        }
        return true;
    }

    private void addDefinition(Element definitionElement) {
        Event event = new Event(definitionElement);
        this.eventDefinitions.put(event.getId(), event);
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument();
        super.beforeSerialize(zipOut, fileName, library);
    }

    void prepareDocument() {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        tabfile.getDocumentElement().removeAttribute("xmlns:xmi");
        for (Event event : this.eventDefinitions.values()) {
            event.buildDom(tabfile.getDocumentElement(), this.library);
        }
        TextElement switchOff = new TextElement("SwitchedOff", "${addOn_Scheduler_Switch}");
        switchOff.buildDom(tabfile.getDocumentElement(), this.library);
    }
}

