/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.types.CompilerVersion;
import ch.e2e.builder.compiler.error.LibraryError;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibraryVersionChecker {
    private HashMap<String, ArrayList<Revision>> revisionsMap;
    private AbstractErrorHandler errorHandler;

    public AbstractErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new AbstractErrorHandler(){};
        }
        return this.errorHandler;
    }

    public LibraryVersionChecker(Document revisionsDocument) throws XPathExpressionException {
        XPath xpath = DomUtilities.newXPath();
        NodeList revisionsList = (NodeList)xpath.evaluate("/table/Revision/LibraryComponent/..", revisionsDocument.getDocumentElement(), XPathConstants.NODESET);
        this.revisionsMap = new HashMap();
        int length = revisionsList.getLength();
        for (int i = 0; i < length; ++i) {
            Element revisionElement = (Element)revisionsList.item(i);
            Revision revision = new Revision(revisionElement);
            ArrayList<Revision> revisions = this.revisionsMap.get(revision.name);
            if (revisions == null) {
                revisions = new ArrayList();
                this.revisionsMap.put(revision.name, revisions);
            }
            revisions.add(revision);
        }
    }

    public boolean doCheck() {
        boolean result = true;
        CompilerVersion minimumCompilerVersion = new CompilerVersion("6.0.17.1");
        Iterator<String> libraries = this.revisionsMap.keySet().iterator();
        while (libraries.hasNext() && result) {
            String library = libraries.next();
            ArrayList<Revision> revisions = this.revisionsMap.get(library);
            boolean compilerNewEnough = revisions.get(0).compilerVersion.isGreaterEqualThan(minimumCompilerVersion);
            if (!compilerNewEnough) {
                HashMap<String, String> parameter = new HashMap<String, String>();
                parameter.put("library.name", revisions.get(0).name);
                String libraryCompilerStringVersion = revisions.get(0).compilerVersion.toString();
                if ("0".equals(libraryCompilerStringVersion)) {
                    libraryCompilerStringVersion = "older than 6.0.17.1";
                }
                parameter.put("library.compiler", libraryCompilerStringVersion);
                parameter.put("compiler.minimum.version", "6.0.17.1");
                LibraryError error = new LibraryError("error.library.old.compiler", parameter);
                this.getErrorHandler().error((AbstractBuilderError)error);
                return false;
            }
            String version = revisions.get(0).version;
            long buildTime = revisions.get(0).buildTime;
            int length = revisions.size();
            for (int i = 1; i < length && result; ++i) {
                Revision revision = revisions.get(i);
                if (buildTime == revision.buildTime && version.equals(revision.version)) continue;
                HashMap<String, String> parameter = new HashMap<String, String>();
                parameter.put("library.name", revision.name);
                LibraryError error = new LibraryError("error.library.different.version", parameter);
                this.getErrorHandler().error((AbstractBuilderError)error);
                result = false;
            }
        }
        return result;
    }

    private class Revision {
        private long buildTime;
        private String version;
        private String name;
        private CompilerVersion compilerVersion;

        private Revision(Element revision) throws XPathExpressionException {
            XPath xpath = DomUtilities.newXPath();
            this.name = ((Attr)xpath.evaluate("LibraryComponent/@name", revision, XPathConstants.NODE)).getValue();
            Attr versionAttr = (Attr)xpath.evaluate("LibraryComponent/@version", revision, XPathConstants.NODE);
            this.version = versionAttr == null ? "" : versionAttr.getValue();
            Attr millis = (Attr)xpath.evaluate("LibraryComponent/@millis", revision, XPathConstants.NODE);
            this.buildTime = millis == null ? 0L : Long.parseLong(millis.getValue());
            Attr compilerVersionAttr = (Attr)xpath.evaluate("CompilerInformation/Compiler/@version", revision, XPathConstants.NODE);
            this.compilerVersion = new CompilerVersion(compilerVersionAttr == null ? "0" : compilerVersionAttr.getValue());
        }
    }
}

