/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.base.event.ShowErrorEvent;
import ch.e2e.builder.base.module.ModuleInterchangeAction;
import ch.e2e.builder.base.module.ModuleInterchangeController;
import ch.e2e.builder.compiler.build.event.BridgeServiceStartedAction;
import ch.e2e.builder.compiler.build.types.BridgeInstance;
import ch.e2e.builder.compiler.build.types.BridgeInstanceProcess;
import ch.e2e.builder.compiler.build.types.ControlPortInUseException;
import ch.e2e.builder.compiler.build.types.LogStreams;
import ch.e2e.builder.compiler.build.types.Logging;
import ch.e2e.builder.compiler.build.types.RuntimeStartupTimeoutException;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.io.ProcessStoppedEvent;
import ch.e2e.io.ProcessStoppedListener;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BridgeInstanceController
implements EventExecuter {
    public static final int STARTED = 0;
    public static final int STARTUP = 1;
    public static final int RUNNING = 2;
    public static final int STOP = 3;
    public static final int SHUTDOWN = 4;
    public static final int STOPPED = 5;
    public static final int UNKNOWN = 6;
    private static final String STARTUP_STRING = "Startup";
    private static final String RUNNING_STRING = "Running";
    private static final String SHUTDOWN_STRING = "Shutdown";
    private static final String METHOD_POST = "POST";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final UriBuilder FILTERS = UriBuilder.fromUri((String)"http://localhost:{port}").path("api/log/channels/{channel}/sinks/{sink}/filters");
    private static BridgeInstanceController instance;
    private HashMap<String, BridgeInstanceProcess> runningInstances = new HashMap();
    private RestartListener restartListener = new RestartListener();

    private BridgeInstanceController() {
    }

    public static BridgeInstanceController getInstance() {
        if (instance == null) {
            instance = new BridgeInstanceController();
        }
        return instance;
    }

    public void start(BridgeInstance instance, LogStreams logStreams) throws TransformerException, IOException, ParserConfigurationException, XPathExpressionException, SAXException, ControlPortInUseException, RuntimeStartupTimeoutException, PlaceholderSubstitutorException {
        BridgeInstance runningInstance = this.checkControlPort(instance);
        if (runningInstance == null) {
            BridgeInstanceProcess process = this.runningInstances.get(instance.getFullQualifiedName());
            if (process == null) {
                if (instance.getDeployment().getCompilableObject().containsJavaService() && this.hasArchitectureConflict()) {
                    EventController.fire((EventObject)new ShowErrorEvent((Object)this, this.getArchitectureConflictErrorMessage()));
                } else {
                    process = new BridgeInstanceProcess(instance, logStreams);
                    this.runningInstances.put(instance.getFullQualifiedName(), process);
                    process.start();
                    this.waitForStartup(instance);
                }
            } else {
                this.restart(instance);
            }
        } else {
            throw new ControlPortInUseException(runningInstance);
        }
    }

    public boolean isRunning(Deployment deployment) {
        return this.getStatus(deployment) == 2;
    }

    public int getStatus(Deployment deployment) {
        BridgeInstance instance = new BridgeInstance(deployment);
        int result = 6;
        if (instance.exists()) {
            BridgeInstanceProcess process = this.runningInstances.get(instance.getFullQualifiedName());
            result = process == null ? 5 : (process.isRunning() ? 2 : 5);
        }
        return result;
    }

    public void stop(final BridgeInstance instance) {
        BridgeInstanceProcess process = this.runningInstances.get(instance.getFullQualifiedName());
        if (process != null && process.isRunning()) {
            process.stop(new ProcessStoppedListener(){

                public void processStopped(ProcessStoppedEvent event) {
                    instance.getDeployment().setStatus(5);
                }
            });
        }
    }

    public void kill(BridgeInstance instance) {
        BridgeInstanceProcess process = this.runningInstances.get(instance.getFullQualifiedName());
        if (process != null && process.isRunning()) {
            process.kill();
        }
    }

    private void restart(BridgeInstance instance) throws TransformerException, IOException, ParserConfigurationException, XPathExpressionException, SAXException, RuntimeStartupTimeoutException, PlaceholderSubstitutorException {
        BridgeInstanceProcess process = this.runningInstances.get(instance.getFullQualifiedName());
        if (process != null) {
            if (process.isRunning()) {
                this.restartListener.setInstance(instance);
                process.stop(this.restartListener);
            } else {
                process.setInstance(instance);
                process.start();
                this.waitForStartup(instance);
            }
        }
    }

    public void execute(EventObject event) {
    }

    private boolean hasArchitectureConflict() {
        String runtimeSystem = System.getProperty("ch.e2e.builder.runtime.system");
        runtimeSystem = runtimeSystem == null ? "win64" : runtimeSystem;
        String javaArchDataModel = System.getProperty("sun.arch.data.model");
        return runtimeSystem.contains("64") && javaArchDataModel.contains("32") || runtimeSystem.contains("32") && javaArchDataModel.contains("64");
    }

    private String getArchitectureConflictErrorMessage() {
        String runtimeSystem = System.getProperty("ch.e2e.builder.runtime.system");
        runtimeSystem = runtimeSystem == null ? "win64" : runtimeSystem;
        String javaArchDataModel = System.getProperty("sun.arch.data.model");
        return "You have installed a " + (runtimeSystem.contains("64") ? "64" : "32") + "bit E2E Bridge runtime\nand you are using a " + (javaArchDataModel.contains("64") ? "64" : "32") + "bit Java Virtual Machine.\nBridge services containing a java adapter, can't start\nwith this combination.";
    }

    private void waitForStartup(BridgeInstance instance) throws RuntimeStartupTimeoutException {
        boolean running = false;
        Date startWaiting = new Date();
        while (!running && !instance.isStopped()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int status = this.getStatus(instance.getControlPort());
            if (status == 2) {
                running = true;
                instance.getDeployment().setStatus(2);
                BridgeServiceStartedAction action = new BridgeServiceStartedAction();
                action.addValue("bridge.instance.name", instance.getFullQualifiedName());
                action.addValue("bridge.instance", instance);
                ModuleInterchangeController.getInstance().fireModuleInterchangeAction((ModuleInterchangeAction)action);
                continue;
            }
            if (startWaiting.getTime() >= new Date().getTime() - 60000L) continue;
            this.kill(instance);
            throw new RuntimeStartupTimeoutException(instance);
        }
    }

    public void reloadTabfile(BridgeInstance instance, String tabfile) {
        if (this.isRunning(instance.getDeployment())) {
            try {
                if (tabfile.startsWith("tabfiles/")) {
                    tabfile = tabfile.substring("tabfiles/".length());
                }
                Document reloadDocument = DomUtilities.newDocument((String)"Reload");
                Element change = reloadDocument.createElement("Change");
                change.setAttribute("file", tabfile);
                reloadDocument.getDocumentElement().appendChild(change);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DomUtilities.serialize((OutputStream)bytes, (Document)reloadDocument, (boolean)false);
                URL url = new URL("http", "localhost", instance.getControlPort(), "/");
                Document response = BridgeInstanceController.doPostRequest(url, bytes.toByteArray(), "text/xml; charset=utf-8");
                DomUtilities.serialize((OutputStream)System.out, (Document)response, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLoggerFilters(BridgeInstance instance, String channel, String sink, String logPropertyName, String logLevel) {
        try (Client client = null;){
            client = ClientBuilder.newBuilder().build();
            Invocation invocation = client.target(FILTERS.build(new Object[]{instance.getControlPort(), channel, sink})).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPut(Entity.json((Object)BridgeInstanceController.createFilterStringJson(logPropertyName, logLevel)));
            try (Response response = invocation.invoke();){
                Response.StatusType statusInfo = response.getStatusInfo();
                if (!statusInfo.getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                    Logging.logger.warning(String.format("Log Level changed: Notifying of Runtime failed! (HTTP status: %d %s)", statusInfo.getStatusCode(), statusInfo.getReasonPhrase()));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String createFilterStringJson(String logPropertyName, String logLevel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getStatus(int port) {
        int result = 5;
        try {
            URL url = new URL("http", "localhost", port, "/");
            Document response = BridgeInstanceController.doPostRequest(url, "<Status />".getBytes("UTF-8"), "text/xml; charset=utf-8");
            try {
                XPath xpath = DomUtilities.newXPath();
                String resultString = (String)xpath.evaluate("/Status/System/text()", response.getDocumentElement(), XPathConstants.STRING);
                if (resultString.equals(STARTUP_STRING)) {
                    result = 1;
                } else if (resultString.equals(RUNNING_STRING)) {
                    result = 2;
                } else if (resultString.equals(SHUTDOWN_STRING)) {
                    result = 4;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document doPostRequest(URL url, byte[] request, String type) throws IOException, ParserConfigurationException, SAXException {
        Document result = null;
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setInstanceFollowRedirects(false);
            con.setRequestMethod(METHOD_POST);
            con.setRequestProperty(CONTENT_TYPE_HEADER, type);
            con.setConnectTimeout(300);
            int length = request.length;
            con.setRequestProperty(CONTENT_LENGTH_HEADER, String.valueOf(length));
            OutputStream os = con.getOutputStream();
            os.write(request, 0, length);
            result = DomUtilities.parse((InputStream)con.getInputStream(), (boolean)false, (boolean)false, (boolean)true);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return result;
    }

    private BridgeInstance checkControlPort(BridgeInstance instance) {
        BridgeInstance result = null;
        for (BridgeInstanceProcess process : this.runningInstances.values()) {
            if (!process.isRunning() || instance.getControlPort() != process.getBridgeInstance().getControlPort() || instance.getFullQualifiedName().equals(process.getBridgeInstance().getFullQualifiedName())) continue;
            result = process.getBridgeInstance();
            break;
        }
        return result;
    }

    private class RestartListener
    implements ProcessStoppedListener {
        private BridgeInstance instance;

        private RestartListener() {
        }

        public void setInstance(BridgeInstance instance) {
            this.instance = instance;
        }

        public void processStopped(ProcessStoppedEvent event) {
            try {
                this.instance.create();
                BridgeInstanceProcess process = (BridgeInstanceProcess)BridgeInstanceController.this.runningInstances.get(this.instance.getFullQualifiedName());
                process.removeStopListener();
                process.setInstance(this.instance);
                process.start();
                BridgeInstanceController.this.waitForStartup(this.instance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

