/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libs;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.build.tasks.uml.UmlHelper;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.library.Library;
import ch.e2e.builder.compiler.uml.BridgeComponent;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LibraryComponentsTask
extends CacheAbleTask
implements XSLTTransformSource {
    private Document result;

    public static Boolean select(String id) {
        return id.endsWith(".library.components.xml");
    }

    public LibraryComponentsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".library.components.xml";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        return result;
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> sourceSet = new HashSet<String>();
        sourceSet.add(this.getSourceId());
        return sourceSet;
    }

    protected String getSourceId() {
        return this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().get(this.getDestinationFileNameWithoutExtension());
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            IDLSource idlSource = (IDLSource)this.getSource(this.getSourceId());
            IDLImportSource idlImportSource = idlSource.getIDLImportSource();
            Document document = DomUtilities.newDocument((String)"http://scheer-group.com/xuml", (String)"xuml:components");
            Element components = document.getDocumentElement();
            Element module = document.createElementNS("http://scheer-group.com/xuml", "xuml:module");
            components.appendChild(module);
            module.appendChild(idlImportSource.getDataModel().getModule().toXmi(document, idlImportSource.getDataModel().getModelId(), UmlHelper.getWorkUmlFolder(this.getSourceManager().getWorkFolder()).getPath()));
            Element library = document.createElementNS("http://scheer-group.com/xuml", "xuml:library");
            components.appendChild(library);
            if (idlImportSource instanceof Library) {
                Element libraryProxy = document.createElementNS("http://scheer-group.com/xuml", "xuml:libraryProxy");
                library.appendChild(libraryProxy);
                BridgeComponent libraryProxyComponent = ((Library)idlImportSource).getLibraryProxy();
                libraryProxy.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getDestinationFileNameWithoutExtension() + ".import.xml" + "#" + libraryProxyComponent.getXmiID());
            }
            DomUtilities.serialize((File)this.getDestinationFile(), (Document)document, (boolean)true);
            this.result = document;
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

