/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class BPMNComponentsTask
extends XSLTTask {
    public static Boolean select(String id) {
        return id.startsWith("model") && id.endsWith(".bpmn.components.xml");
    }

    public BPMNComponentsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.bpmn.components";
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add("project.xml");
        XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource("project.xml")).getJsonDocument(XumlProject.class);
        result.add(Files.model__PROJECTNAME_configuration_service_xmiTransformationModel_rId_xml(projectDocument.getName()));
        try {
            Path projectPath = this.getSourceManager().getProjectFolder().toPath();
            this.sourceManager.getSourceFilesStream().filter(path -> {
                String s = projectPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), "/");
                return s.endsWith(".bpmn.json");
            }).forEach(path -> result.add(Files.bpmn__PROCESS_bpmn_service_xmiTransformationModel_rId_xml(path.getFileName().toString().replace(".bpmn.json", ""))));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

