/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.MultipleOutputsCacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.utils.ClientUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class NodeJsTask
extends MultipleOutputsCacheAbleTask {
    protected final Path outputLogPath;
    protected final Path errorLogPath;

    public NodeJsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
        this.outputLogPath = sourceManager.getWorkFolder().toPath().resolve(id + ".log.txt");
        this.errorLogPath = sourceManager.getWorkFolder().toPath().resolve(id + ".errors" + ".log.txt");
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        this.executeRestOperation(dependencyLevel);
    }

    protected String getMethod() {
        return "POST";
    }

    protected void executeRestOperation(int dependencyLevel) {
        Client client = ClientUtils.getClient();
        try (Response response = client.target(this.getBaseUrl()).path(this.getActionPath()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).build(this.getMethod(), this.getEntity()).invoke();){
            this.handleResponse(response);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    protected abstract String getBaseUrl();

    protected abstract String getActionPath();

    protected abstract Entity<?> getEntity();

    protected abstract void handleResponse(Response var1) throws Exception;

    protected void handleError(Exception e) {
        this.getErrorHandler().error((Throwable)e);
    }

    protected void log(String logMessage) {
        this.log(logMessage, this.outputLogPath);
    }

    protected void logError(String logMessage) {
        this.log(logMessage, this.errorLogPath);
    }

    protected void logError(Exception error) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            error.printStackTrace(pw);
            this.logError(sw.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void log(String logMessage, Path logFile) {
        try {
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
            if (Files.notExists(logFile, new LinkOption[0])) {
                Files.createFile(logFile, new FileAttribute[0]);
            }
            Files.write(logFile, logMessage.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

