/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration;

import ch.e2e.ant.gui.configuration.DefaultAntProjectFactory;
import ch.e2e.resource.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.Project;
import org.w3c.dom.Document;

public abstract class AntProjectFactory {
    private static final String implementationSearch = "ch.e2e.ant.AntProjectFactory";
    private static ArrayList<String> taskdefResources = new ArrayList();
    private static HashMap<String, String> taskdefs = new HashMap();
    private static ArrayList<String> typedefResources = new ArrayList();
    private static HashMap typedefs = new HashMap();

    protected AntProjectFactory() {
        taskdefResources.add("ch.e2e.ant.properties.taskdefs");
        typedefResources.add("ch.e2e.ant.properties.typedefs");
    }

    public abstract void registerAntDocument(String var1, Document var2);

    public abstract Project getProject(String var1, Properties var2, File var3) throws IOException, TransformerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AntProjectFactory newInstance() {
        AntProjectFactory result = null;
        String factoryName = System.getProperty(implementationSearch);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (factoryName == null) {
            String searchString = "META-INF/services/ch.e2e.ant.AntProjectFactory";
            InputStream is = classLoader == null ? ClassLoader.getSystemResourceAsStream(searchString) : classLoader.getResourceAsStream(searchString);
            if (is != null) {
                BufferedReader rd = null;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    factoryName = rd.readLine();
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        if (rd != null) {
                            rd.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (factoryName != null) {
            result = AntProjectFactory.createProjectFactory(classLoader, factoryName, result);
        }
        if (result == null) {
            result = new DefaultAntProjectFactory();
        }
        return result;
    }

    private static AntProjectFactory createProjectFactory(ClassLoader classLoader, String factoryName, AntProjectFactory result) {
        try {
            Class<?> clazz = classLoader == null ? ClassLoader.getSystemClassLoader().loadClass(factoryName) : classLoader.loadClass(factoryName);
            if (clazz != null) {
                result = (AntProjectFactory)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void addTaskdefResource(String resource) {
        taskdefResources.add(resource);
    }

    public static void addTaskdef(String taskname, String taskclass) {
        taskdefs.put(taskname, taskclass);
    }

    public static HashMap<String, String> getTaskdefs() {
        return taskdefs;
    }

    protected static ArrayList<String> getTaskdefResources() {
        return taskdefResources;
    }

    public static void addTypedefResource(String resource) {
        typedefResources.add(resource);
    }

    public static void addTypedef(String typename, String typeclass) {
        typedefs.put(typename, typeclass);
    }

    public static HashMap getTypedefs() {
        return typedefs;
    }

    protected static ArrayList<String> getTypedefResources() {
        return typedefResources;
    }

    public void addProperties(Project project, Properties properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            project.setProperty(key, properties.getString(key));
        }
    }

    public void removeProperties(Project project, Properties properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            project.setProperty(key, null);
        }
    }
}

