/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.TypeMapper;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import java.io.File;
import org.w3c.dom.Element;

public class DataContainer
extends UmlObject {
    public DataContainer(String name, UmlObject parent, Element element) {
        super(element, name);
        this.parent = parent;
    }

    public DataContainer(String name, UmlObject parent, Element element, TraceContainer traceContainer) {
        super(element, name, traceContainer);
        this.parent = parent;
    }

    @Override
    protected void addChild(Element child, File documentFile) {
        String name = child.getNodeName();
        String type = child.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        String value = child.hasChildNodes() ? child.getFirstChild().getNodeValue() : "";
        Data data = new Data(name, value, type);
        String objectId = child.getAttribute("objectId");
        if (objectId.length() == 0) {
            data.setObjectId(child);
        } else {
            this.setObjectId(objectId);
        }
        this.addChild(data);
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        String name = child.getNodeName();
        String type = TypeMapper.mapTypes(child, traceContainer.getNamespaceContext());
        String value = traceContainer.addIOEntry(child, this.name);
        Data data = new Data(name, value, type);
        data.setObjectId(child);
        this.addChild(data);
    }
}

