/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.AdapterIO;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.IterationUmlObject;
import ch.e2e.builder.trace.testcase.uml.IteratorFlow;
import ch.e2e.builder.trace.testcase.uml.UmlObjectWithDiagram;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Adapter
extends IOUmlObject
implements UmlObjectWithDiagram,
IterationUmlObject {
    private int id = -1;
    private boolean mockup = false;

    public Adapter(Element element, File documentFolder) {
        super(element, documentFolder);
        this.id = DomUtilities.getInt((Element)element, (String)"id", (int)-1);
        this.mockup = DomUtilities.getBoolean((Element)element, (String)"mockup", (boolean)false);
    }

    public Adapter(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        this.mockup = DomUtilities.getBoolean((Element)element, (String)"mockup", (boolean)false);
    }

    public Adapter(Element element, TraceContainer traceContainer, boolean addToContainer) {
        this(element, traceContainer);
        if (addToContainer) {
            traceContainer.addIterationElement(this, element);
            if (this.id > 0) {
                int i;
                ArrayList<Node> childsToRemove = new ArrayList<Node>();
                NodeList children = element.getChildNodes();
                int length = children.getLength();
                for (i = 0; i < length; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeName().equals("input") || child.getNodeName().equals("output")) continue;
                    childsToRemove.add(child);
                }
                length = childsToRemove.size();
                for (i = 0; i < length; ++i) {
                    element.removeChild((Node)childsToRemove.get(i));
                }
            }
        }
    }

    @Override
    public int internalGetType() {
        return this.mockup ? 10049 : 10003;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public boolean isMockup() {
        return this.mockup;
    }

    @Override
    public String getOriginalName() {
        return this.id == -1 ? super.getOriginalName() : super.getOriginalName() + "_" + this.id;
    }

    @Override
    public boolean hasDiagram() {
        return this.getParent() instanceof IteratorFlow;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public AdapterIO getAdapterIO() {
        return this.getFirstChild(AdapterIO.class);
    }

    public String getAdapterType() {
        return this.getClass().getSimpleName();
    }

    public String getSource() {
        if (this.isMockup()) {
            return null;
        }
        AdapterIO adapterIO = this.getAdapterIO();
        return adapterIO == null ? null : adapterIO.getSource();
    }

    public String getTarget() {
        if (this.isMockup()) {
            return "MOCKED";
        }
        AdapterIO adapterIO = this.getAdapterIO();
        return adapterIO == null ? null : adapterIO.getTarget();
    }
}

