/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.response;

import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.response.Logging;
import ch.e2e.builder.trace.testcase.uml.IOContainer;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.IterationUmlObject;
import ch.e2e.builder.trace.testcase.uml.ParentState;
import ch.e2e.builder.trace.testcase.uml.RootObject;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.dom.BridgeNamespaceContext;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TraceContainer
implements Logging {
    private Map<String, Integer> genericIds = new HashMap<String, Integer>();
    private IOContainer ioContainer;
    private Document traceErrorDocument;
    private Testcase testcase;
    private BridgeNamespaceContext namespaceContext = new BridgeNamespaceContext(new Node[0]);

    public TraceContainer(Testcase testcase) {
        this.testcase = testcase;
        this.ioContainer = new IOContainer(testcase.getIOFile());
    }

    public abstract RootObject createRootObject(Element var1);

    public void close(Document responseDoc) throws IOException, TransformerException {
        this.ioContainer.close();
        this.testcase.getTraceFolder().mkdirs();
        if (this.traceErrorDocument != null) {
            DomUtilities.serialize((File)new File(this.testcase.getTraceFolder(), "trace.errors"), (Document)this.traceErrorDocument, (boolean)false);
        }
    }

    public IOContainer getIOContainer() {
        return this.ioContainer;
    }

    public String addIOEntry(Element ioNode, String type) {
        return this.ioContainer.addIOEntry(ioNode, type);
    }

    public <T extends IOUmlObject> void addIterationElement(T object, Element element) {
        int id = this.newGenericId(object.getOriginalName());
        ((IterationUmlObject)((Object)object)).setId(id);
        element.setAttribute("id", String.valueOf(id));
        Document genericDocument = DomUtilities.newDocument();
        Node importedNode = genericDocument.importNode(element, true);
        genericDocument.appendChild(importedNode);
        try {
            DomUtilities.serialize((File)new File(this.getTestcase().getTraceFolder(), object.getFilename() + ".xml"), (Document)genericDocument, (boolean)false);
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "addAdapter", e);
        }
    }

    private int newGenericId(String key) {
        Integer id = this.genericIds.get(key);
        this.genericIds.put(key, id == null ? (id = Integer.valueOf(1)) : (id = Integer.valueOf(id + 1)));
        return id;
    }

    public void addTraceError(Element traceError) {
        if (this.traceErrorDocument == null) {
            this.traceErrorDocument = DomUtilities.newDocument((String)"TraceErrors");
        }
        Node importedError = this.traceErrorDocument.importNode(traceError, true);
        this.traceErrorDocument.getDocumentElement().appendChild(importedError);
    }

    public Testcase getTestcase() {
        return this.testcase;
    }

    public String addScript(Script script) {
        String id = this.ioContainer.addScript(script);
        script.setIoId(id);
        return id;
    }

    public void addElement(ParentState parentState, Element element) {
    }

    public BridgeNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void addNamespaces(Element element) {
        this.namespaceContext.addNamespaces((Node)element);
    }
}

