/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.ParameterFactory;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.dom.DomUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComplexParameter
extends RecordParameter {
    private String typeName;

    public ComplexParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public ComplexParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder, namespaceAware);
        String string = this.typeName = namespaceAware ? parameterElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type") : parameterElement.getAttribute("type");
        if (DomUtilities.getBoolean((Element)parameterElement, (String)"recursive", (boolean)false)) {
            this.setRecursive(true);
        } else {
            String text;
            Node child = parameterElement.getFirstChild();
            if (child != null && (text = child.getTextContent()) != null && text.contains("recursive")) {
                this.setRecursive(true);
            }
        }
        ParameterFactory.createParameter(parameterElement.getChildNodes(), this.items, this.names, false, this, definitionHolder, namespaceAware);
    }

    private ComplexParameter(String name, String typeName, int type, boolean arrayItem, boolean recursive, String namespace, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, namespace, parent, definitionHolder);
        this.typeName = typeName;
        this.setRecursive(recursive);
    }

    @Override
    public ComplexParameter copy(RecordParameter parent) {
        ComplexParameter result = new ComplexParameter(this.getName(), this.typeName, this.getType(), this.isArrayItem(), this.isRecursive(), this.getNamespace(), parent, this.getDefinitionHolder());
        result.setValue(this.getValue());
        if (!this.isNull()) {
            result.setNil(false);
            for (Parameter parameter : this.items) {
                result.addItem(parameter.copy(result));
            }
        }
        return result;
    }

    @Override
    public Element createSOAPParameter(Document document) {
        Element parameter = document.createElement(this.getName());
        String type = this.getPrefix() == null ? this.getTypeName() : this.getPrefix() + ':' + this.getTypeName();
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", type);
        ParameterFactory.appendSOAPChilds(this.items, parameter, document);
        return parameter;
    }

    @Override
    public Element createEmptySOAPParameter(Document document) {
        Element parameter = document.createElement(this.getName());
        String type = this.getPrefix() == null ? this.getTypeName() : this.getPrefix() + ':' + this.getTypeName();
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", type);
        parameter.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        return parameter;
    }

    @Override
    public String getDiagramName() {
        return null;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Parameter createEmptyParameter(RecordParameter parent) {
        return new ComplexParameter(this.getName(), this.typeName, this.getType(), this.isArrayItem(), this.isRecursive(), this.getNamespace(), parent, this.getDefinitionHolder());
    }

    @Override
    public boolean differsFrom(Parameter other) {
        return !(other instanceof ComplexParameter) || !this.typeName.equals(((ComplexParameter)other).typeName) || super.differsFrom(other);
    }
}

