/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase;

import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.builder.trace.testcase.TestcaseMerger;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.event.SelectTestcaseEvent;
import ch.e2e.builder.trace.testcase.request.RequestTemplate;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractTestcaseFolder
extends TestcaseContainer {
    private static TestcaseFileFilter testcaseFileFilter = new TestcaseFileFilter();
    private SynchronousTestcaseTemplate template;
    private File home;

    public AbstractTestcaseFolder(SynchronousTestcaseTemplate template, File home) {
        super(template.getOperation(), 5);
        this.template = template;
        this.home = home;
        this.readTestcases();
    }

    public abstract AbstractSynchronousTestcase createNewTestcase(String var1);

    public SynchronousTestcaseTemplate getTemplate() {
        return this.template;
    }

    public String getQualifiedOperationName() {
        String qualifiedName;
        SynchronousTestcaseTemplate template = this.getTemplate();
        if (template.isRPCEncoding()) {
            RequestTemplate requestTemplate = template.getRequestTemplate();
            qualifiedName = requestTemplate.getNamespace() + "." + requestTemplate.getName();
        } else {
            qualifiedName = template.getSoapAction();
        }
        return qualifiedName;
    }

    public String findDefaultTestcaseName() {
        return this.findUniqueTestcaseName(this.template.getOperation());
    }

    public String findUniqueTestcaseName(String template) {
        String startswith;
        String name = startswith = template.replaceFirst("[0-9]*$", "");
        int i = 1;
        while (this.exists(name)) {
            name = startswith + i;
            ++i;
        }
        return name;
    }

    public AbstractSynchronousTestcase createDefaultTestcase() throws IOException {
        return this.createTestcase(this.template.getOperation());
    }

    public AbstractSynchronousTestcase createTestcase(String testcaseName) throws IOException {
        AbstractSynchronousTestcase testcase = this.createNewTestcase(testcaseName);
        try {
            Document requestDocument = this.template.isRPCEncoding() ? this.template.getRequestTemplate().createEmptyRequest() : this.createDocumentEncodedRequest();
            DomUtilities.serialize((File)testcase.getRequestFile(), (Document)requestDocument, (boolean)true);
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(this.getClass().getName(), "createTestcase", e);
        }
        this.add(testcase);
        return testcase;
    }

    public void mergeTestcases(SynchronousTestcaseTemplate template) {
        this.template = template;
        int length = this.getChildCount();
        for (int i = 0; i < length; ++i) {
            AbstractSynchronousTestcase testcase = (AbstractSynchronousTestcase)this.getChild(i);
            TestcaseMerger.merge(template, testcase);
            testcase.setStatus(7);
            testcase.saveLastRunDate();
        }
    }

    @Override
    public int hashCode() {
        return this.home.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof AbstractTestcaseFolder) {
            result = this.home.equals(((AbstractTestcaseFolder)obj).home);
        }
        return result;
    }

    public void renameTestcase(AbstractSynchronousTestcase testcase, String newName) {
        this.getChildren().remove(testcase.getName());
        testcase.renameTo(newName);
        this.getChildren().put(testcase.getName(), testcase);
    }

    public File getHome() {
        return this.home;
    }

    protected void setHome(File newHome) {
        this.home = new File(newHome, this.home.getName());
        this.getTemplate().setHome(this.home);
        for (TestcaseObject o : this.getChildren().values()) {
            if (!(o instanceof AbstractSynchronousTestcase)) continue;
            ((AbstractSynchronousTestcase)o).setHome(this.home);
        }
    }

    protected void deleteTestCases() throws FilesNotDeletedException {
        ArrayList undeletedFiles = new ArrayList();
        ArrayList<TestcaseObject> children = new ArrayList<TestcaseObject>(this.getChildren().values());
        for (TestcaseObject testCase : children) {
            try {
                this.delete(testCase);
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    private void readTestcases() {
        File[] testcaseFiles;
        for (File testcaseFile : testcaseFiles = FileUtilities.getFileList((File)this.home, (FileFilter)testcaseFileFilter)) {
            String name = testcaseFile.getName();
            AbstractSynchronousTestcase testcase = this.createNewTestcase(name = name.substring(0, name.length() - ".testcase".length()));
            if (testcase.getRequestFile().exists()) {
                EventController.fire((EventObject)new SelectTestcaseEvent(this, testcase));
                this.add(testcase);
                continue;
            }
            if (testcaseFile.delete()) continue;
            logger.info("Could not delete file '" + testcaseFile.getPath() + "'");
        }
    }

    private Document createDocumentEncodedRequest() throws ParserConfigurationException, SAXException, IOException {
        Document requestDocument = DomUtilities.newDocument();
        Document templateDocument = DomUtilities.parse((File)this.template.getTemplateFile(), (boolean)false, (boolean)false);
        Element requestElement = (Element)templateDocument.getElementsByTagName("Request").item(0);
        NodeList children = requestElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            requestDocument.appendChild(requestDocument.importNode(child, true));
            break;
        }
        return requestDocument;
    }

    private static class TestcaseFileFilter
    implements FileFilter {
        private TestcaseFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".testcase");
        }
    }
}

