/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.plugin.module;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.event.RefreshEvent;
import ch.e2e.builder.base.licensing.CheckLicenseEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.plugin.module.ModuleFrame;
import ch.e2e.builder.base.plugin.module.ModulePlugin;
import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.logging.JavaConsole;
import ch.e2e.swing.FloatingFrame;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class FloatingModuleFrame
extends FloatingFrame
implements ModuleFrame,
WindowFocusListener {
    private ModulePlugin plugin;
    private JComponent overview;

    public FloatingModuleFrame(ModulePlugin plugin) {
        super(E2EBuilder.getInstance().getApplicationFrame(), plugin.getModule().getTitle(), false);
        this.plugin = plugin;
        this.setIconImage(E2EBuilderIcons.APPLICATION_ICON);
        this.overview = plugin.getModule().getOverviewPanel();
        this.add(this.overview, "Center");
        this.addEventHandler();
        this.addKeyBindings();
    }

    private void addEventHandler() {
        this.plugin.getModule().addProjectListener(new ProjectListener(){

            public void projectSettingsChange(ProjectEvent event) {
                FloatingModuleFrame.this.setProjectName(event.getProject().getName());
            }

            public void doBeforeProjectOpen(ProjectEvent event) {
            }

            public void doAfterProjectOpen(ProjectEvent event) {
            }

            public void projectOpened(ProjectEvent event) {
            }

            public void doBeforeChanging(ProjectEvent event) {
            }
        });
        this.addWindowFocusListener(this);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                FloatingModuleFrame.this.checkLicense();
            }
        }, CheckLicenseEvent.class);
    }

    @Override
    public void setProjectName(String projectName) {
        this.setTitle(this.plugin.getModule().getTitle() + " - " + projectName);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        E2EBuilder.getInstance().setActiveModule(this.plugin.getModule());
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void setVisibility(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.plugin.windowOpened();
            Rectangle bounds = this.getBounds();
            if (bounds.width == 0 || bounds.height == 0) {
                this.pack();
                Rectangle parentBounds = E2EBuilder.getInstance().getApplicationFrame().getBounds();
                Dimension size = this.getSize();
                int x = parentBounds.x + parentBounds.width - size.width - 5;
                int y = parentBounds.y + 15;
                int width = Math.min(parentBounds.width - 10, size.width);
                int height = Math.min(parentBounds.height - 20, size.height);
                this.setBounds(x, y, width, height);
            }
        } else {
            this.plugin.windowClosed();
        }
        this.getModule().getProperties().setProperty("builder.plugin.frame.visible", visible);
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.plugin.getModule();
    }

    @Override
    public void toFront() {
    }

    private void addKeyBindings() {
        InputMap inputMap = this.getRootPane().getInputMap(1);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control F3"), "javaconsole.E2EBuilder.plugin." + this.getModule().getName());
        actionMap.put("javaconsole.E2EBuilder.plugin." + this.getModule().getName(), new AbstractAction("javaconsole.E2EBuilder.plugin." + this.getModule().getName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                JavaConsole.revertVisibility();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("F5"), "refresh.E2EBuilder.plugin." + this.getModule().getName());
        actionMap.put("refresh.E2EBuilder.plugin." + this.getModule().getName(), new AbstractAction("refresh.E2EBuilder.plugin." + this.getModule().getName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                EventController.fire((EventObject)((Object)new RefreshEvent(this)));
            }
        });
    }

    private void checkLicense() {
        this.remove(this.overview);
        this.overview = this.plugin.getModule().getOverviewPanel();
        this.add(this.overview, "Center");
    }
}

