/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application;

import ch.e2e.builder.base.application.Logging;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class ModulePropertiesPool
implements Logging {
    private static final File propertiesHome = new File(System.getProperty("user.home") + File.separator + ".e2ebuilder");
    private static final String PROPERTIES_EXTENSION = ".properties";
    private HashMap<String, Properties> moduleProperties = new HashMap();
    private String propertiesPrefix;

    ModulePropertiesPool(String propertiesPrefix) {
        this.propertiesPrefix = propertiesPrefix + '.';
    }

    public Properties getProperties(String moduleName, Class moduleClass) {
        Properties properties = this.moduleProperties.get(moduleName);
        if (properties == null) {
            properties = this.createProperties(moduleName, moduleClass);
            this.moduleProperties.put(moduleName, properties);
        }
        this.readSuperClassProperties(moduleClass.getSuperclass());
        return properties;
    }

    void saveAllProperties() {
        for (Properties properties : this.moduleProperties.values()) {
            try {
                if (properties.isEmpty()) continue;
                properties.write(false);
            }
            catch (IOException ioEx) {
                logger.severe("Caught a " + ioEx.getClass().getName() + ".");
                logger.throwing(this.getClass().getName(), "saveAllProperties", ioEx);
            }
        }
    }

    private Properties createProperties(String moduleName, Class moduleClass) {
        String filename = this.propertiesPrefix + StringTools.removeAllSpaces((String)moduleName);
        File propertiesFile = new File(propertiesHome, filename + PROPERTIES_EXTENSION);
        return this.storeSystemProperties(propertiesFile, moduleClass);
    }

    private Properties storeSystemProperties(File propertiesFile, Class moduleClass) {
        Properties properties = new Properties(propertiesFile);
        String keyPrefix = moduleClass.getPackage().getName() + '.';
        for (Object o : properties.keySet()) {
            String key = (String)o;
            System.setProperty(keyPrefix + key, properties.get((Object)key).toString());
        }
        return properties;
    }

    private void readSuperClassProperties(Class superclass) {
        Properties properties;
        if (superclass != null && (properties = this.moduleProperties.get(superclass.getName())) == null) {
            String packageName = superclass.getPackage().getName();
            String classname = superclass.getName().substring(packageName.length() + 1).toLowerCase();
            String filename = this.propertiesPrefix + StringTools.removeAllSpaces((String)classname);
            File propertiesFile = new File(propertiesHome, filename + PROPERTIES_EXTENSION);
            if (propertiesFile.exists()) {
                properties = this.storeSystemProperties(propertiesFile, superclass);
                this.moduleProperties.put(superclass.getName(), properties);
                this.readSuperClassProperties(superclass.getSuperclass());
            }
        }
    }
}

