/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.build.process.CompileProcess;
import ch.e2e.builder.compiler.build.test.RepositoryCompare;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.resource.MultiMapProperties;
import ch.e2e.resource.Properties;
import ch.e2e.test.E2EAssert;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.Utilities;
import ch.e2e.test.options.BooleanOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;

public class BuildRepositoryTest
extends E2ETest {
    public static final String KEY_TEST_TYPE_NAME = "buildRepositoryTest";
    public static final String KEY_OPTION_UML_DOCUMENT = "compile.test.uml.document";
    public static final String KEY_OPTION_DEPLOYMENT = "compile.test.deployment";
    public static final String KEY_OPTION_REPOSITORY = "compile.test.repository";
    public static final String KEY_OPTION_CLEAN_BEFORE_COMPILE = "compile.test.clean.before.compile";
    public static final String KEY_OPTION_PROJECT_FOLDER = "compile.test.project.folder";
    private static final MultiMapProperties errorProperties = new MultiMapProperties("ch.e2e.builder.compiler.properties.xslt.messages", "translation_maps");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest() throws Exception {
        File sourceFolder = new File(new File(E2EBuilderProject.getProjectFolderName()), "uml");
        CompilerConstants.setProjectValue((String)"uml", (String)sourceFolder.getAbsolutePath());
        File projectFolder = (File)this.getOptionValue(KEY_OPTION_PROJECT_FOLDER);
        if (projectFolder == null) {
            projectFolder = new File(E2EBuilderProject.getProjectFolderName());
        }
        String globalProjectFolder = E2EBuilderProject.getProjectFolderName();
        E2EBuilderProject.setProjectFolderName((String)projectFolder.getAbsolutePath());
        try {
            File umlFile = (File)this.getOptionValue(KEY_OPTION_UML_DOCUMENT);
            UmlDocumentCompilerSettings compilerSettings = new UmlDocumentCompilerSettings(projectFolder);
            UmlDocumentFactory umlDocumentFactory = new UmlDocumentFactory(compilerSettings);
            UmlDocument umlDocument = umlDocumentFactory.getUmlDocument(umlFile);
            String deploymentName = (String)this.getOptionValue(KEY_OPTION_DEPLOYMENT);
            File repository = (File)this.getOptionValue(KEY_OPTION_REPOSITORY);
            boolean clean = (Boolean)this.getOptionValue(KEY_OPTION_CLEAN_BEFORE_COMPILE);
            if (clean) {
                new CompileProcess(umlDocument).run("Clean_All_Task");
            }
            new CompileProcess(umlDocument).run("Xmi2Descriptor_Task");
            if (umlDocument.getErrorCount() > 0) {
                ArrayList<ErrorDetail> errorDetails = this.fillErrorDetails(umlDocument);
                E2EAssert.fail((String)("Building descriptor of '" + umlDocument.getName() + "' failed."), errorDetails);
            } else {
                if (repository.exists()) {
                    repository.delete();
                }
                Deployment deployment = this.deployment(umlDocument, deploymentName);
                BuildRepositoryTest.assertNotNull((String)(deploymentName + " does not exist in " + umlDocument.getName()), (Object)deployment);
                this.buildDeployment(umlDocument, deployment, repository);
                if (umlDocument.getErrorHandler().getErrorCount() > 0) {
                    ArrayList<ErrorDetail> errorDetails = this.fillErrorDetails(umlDocument);
                    E2EAssert.fail((String)("Building of deployment '" + deploymentName + "' in '" + umlDocument.getName() + "' failed."), errorDetails);
                }
            }
        }
        finally {
            E2EBuilderProject.setProjectFolderName((String)globalProjectFolder);
        }
    }

    private ArrayList<ErrorDetail> fillErrorDetails(UmlDocument umlDocument) {
        ArrayList<ErrorDetail> errorDetails = new ArrayList<ErrorDetail>();
        for (AbstractBuilderError error : umlDocument.getEXMIErrorHandler().getErrors()) {
            errorDetails.add(new ErrorDetail((Object)this.getErrorDetails((BuilderError)error)));
        }
        for (AbstractBuilderError error : umlDocument.getEXMIErrorHandler().getFatalErrors()) {
            errorDetails.add(new ErrorDetail((Object)this.getErrorDetails((BuilderError)error)));
        }
        for (AbstractBuilderError error : umlDocument.getErrorHandler().getErrors()) {
            errorDetails.add(new ErrorDetail((Object)this.getErrorDetails((BuilderError)error)));
        }
        for (AbstractBuilderError error : umlDocument.getErrorHandler().getFatalErrors()) {
            errorDetails.add(new ErrorDetail((Object)this.getErrorDetails((BuilderError)error)));
        }
        return errorDetails;
    }

    private String getErrorDetails(BuilderError error) {
        String details;
        try {
            details = errorProperties.getString(error.getCode() + ".short");
            details = StringTools.replaceProperties((String)details, (Map)error.getParameter());
        }
        catch (MissingResourceException e) {
            details = error.getClass().getName() + ": " + error.getCode();
        }
        return details;
    }

    public String getRecommendedCompareType() {
        return null;
    }

    public void setTestFolder(File testFolder) {
        super.setTestFolder(testFolder);
        FileOption repository = (FileOption)this.getOption(KEY_OPTION_REPOSITORY);
        File defaultValue = new File(testFolder, "${compile.test.uml.document.name}/${compile.test.deployment}.rep");
        repository.setDependencyString(defaultValue.getAbsolutePath());
        repository.setDefaultValue((Object)defaultValue);
        if (this.getResult() != null) {
            this.prepareCompareTypes();
        }
    }

    public void prepareCompareType(ResultCompare compare) {
        if (compare instanceof RepositoryCompare) {
            Option testFile = (Option)compare.getOptions().get("xml.compare.test.file");
            testFile.addDependency(KEY_OPTION_REPOSITORY);
            testFile.setDependencyString("${compile.test.repository}");
            testFile.setDefaultValue((Object)new File("${compile.test.repository}"));
            if (this.getReferenceFolder() != null) {
                Option referenceFile = (Option)compare.getOptions().get("xml.compare.reference.file");
                File defaultValue = new File(this.getReferenceFolder(), "${compile.test.uml.document.name}/${xml.compare.test.file.name}");
                referenceFile.setDependencyString(defaultValue.getAbsolutePath());
                referenceFile.setDefaultValue((Object)defaultValue);
                referenceFile.addDependency("xml.compare.test.file");
                referenceFile.addDependency(KEY_OPTION_UML_DOCUMENT);
            }
        }
    }

    public void setReferenceFolder(File referenceFolder) {
        super.setReferenceFolder(referenceFolder);
        if (this.getResult() != null) {
            this.prepareCompareTypes();
        }
    }

    public void removeOutputData() {
        File repository = (File)this.getOptionValue(KEY_OPTION_REPOSITORY);
        if (repository != null) {
            repository.delete();
            Utilities.deleteEmptyParents((File)repository);
        }
    }

    protected void createOptions() {
        FileOption umlDocument = new FileOption("UML Document", KEY_OPTION_UML_DOCUMENT, 0);
        umlDocument.setRequired(true);
        umlDocument.setDirectory(false);
        umlDocument.addFileExtension("xml", "UML Document");
        umlDocument.addFileExtension("xml.zip", "UML Document");
        this.addOption(KEY_OPTION_UML_DOCUMENT, (Option)umlDocument);
        StringOption deployment = new StringOption("Deployment", KEY_OPTION_DEPLOYMENT, 1);
        deployment.setRequired(true);
        this.addOption(KEY_OPTION_DEPLOYMENT, (Option)deployment);
        FileOption repository = new FileOption("Repository", KEY_OPTION_REPOSITORY, 2);
        repository.setRequired(true);
        repository.setDirectory(false);
        repository.addFileExtension("rep", "E2E Bridge Repository");
        this.addOption(KEY_OPTION_REPOSITORY, (Option)repository);
        repository.addDependency(KEY_OPTION_UML_DOCUMENT);
        repository.addDependency(KEY_OPTION_DEPLOYMENT);
        repository.setDependencyString("${compile.test.uml.document.name}/${compile.test.deployment}");
        repository.setDefaultValue((Object)new File("${compile.test.uml.document.name}/${compile.test.deployment}.rep"));
        BooleanOption clean = new BooleanOption("Clean before compile", "Do not clean before compile", KEY_OPTION_CLEAN_BEFORE_COMPILE, true, true, 3);
        this.addOption(KEY_OPTION_CLEAN_BEFORE_COMPILE, (Option)clean);
        String defaultName = "Build repository of ${compile.test.deployment}";
        this.getNameOption().addDependency(KEY_OPTION_DEPLOYMENT);
        this.getNameOption().setDependencyString(defaultName);
        this.getNameOption().setDefaultValue((Object)defaultName);
        FileOption projectFolder = new FileOption("Project Folder", KEY_OPTION_PROJECT_FOLDER, 4);
        projectFolder.setRequired(false);
        projectFolder.setDirectory(true);
        this.addOption(KEY_OPTION_PROJECT_FOLDER, (Option)projectFolder);
    }

    private void buildDeployment(UmlDocument umlDocument, Deployment deployment, File repository) {
        CompilableObject composite = deployment.getCompilableObject();
        CompileProcess process = new CompileProcess(umlDocument, composite.getName());
        process.setRepositoryOutputFile(composite.getName(), repository);
        process.run("Repository_Task");
    }

    private Deployment deployment(UmlDocument umlDocument, String deploymentName) {
        Deployment deployment = null;
        Iterator deployments = umlDocument.getDescriptor().getDeploymentIterator();
        while (deployments.hasNext() && deployment == null) {
            Deployment next = (Deployment)deployments.next();
            if (!next.getName().equals(deploymentName)) continue;
            deployment = next;
        }
        return deployment;
    }

    static {
        errorProperties.addProperties(new Properties("ch.e2e.builder.compiler.properties.errors"));
    }
}

