/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.GroupingCell;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.UmlGraphFileCorruptException;
import ch.e2e.builder.trace.gui.uml.UmlGraphLayoutCorruptException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class UmlGraph
extends JGraph {
    private static final int EXEC_CLICK_COUNT = 1;
    private final E2ETraceModule module;
    private long runDate;

    public UmlGraph(E2ETraceModule module, GraphModel model, GraphLayoutCache cache) {
        super(model, cache, (BasicMarqueeHandler)new UmlMarqueeHandler());
        this.configure();
        this.module = module;
    }

    public E2ETraceModule getModule() {
        return this.module;
    }

    public long getRunDate() {
        return this.runDate;
    }

    public void setRunDate(long runDate) {
        this.runDate = runDate;
    }

    public String getToolTipText(MouseEvent e) {
        Object c;
        String text = null;
        if (e != null && (c = this.getFirstCellForLocation(e.getX(), e.getY())) != null && ((text = UmlGraphConstants.getToolTipText((Map)this.getAttributes(c))) == null || text.isEmpty())) {
            text = this.convertValueToString(c);
        }
        return text;
    }

    public void saveLayout(File file) throws FileNotFoundException {
        this.saveLayout(new FileOutputStream(file));
    }

    public void saveLayout(OutputStream out) {
        ArrayList<Rectangle2D> geoms = new ArrayList<Rectangle2D>();
        for (Object cell : this.getCells()) {
            Cloneable geom = null;
            if (cell instanceof Edge) {
                List points = UmlGraphConstants.getPoints((Map)((Edge)cell).getAttributes());
                if (points != null && points.size() > 2) {
                    geom = new ArrayList(points.subList(1, points.size() - 1));
                }
            } else if (cell instanceof GraphCell && (geom = UmlGraphConstants.getBounds((Map)((GraphCell)cell).getAttributes())) != null && !(geom instanceof Serializable)) {
                Rectangle2D r = geom;
                geom = new AttributeMap.SerializableRectangle2D(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            }
            geoms.add((Rectangle2D)geom);
        }
        if (!geoms.isEmpty()) {
            XMLEncoder encoder = new XMLEncoder(out);
            if (E2EBuilder.development) {
                encoder.setExceptionListener(new ExceptionListener(){

                    @Override
                    public void exceptionThrown(Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            encoder.writeObject(geoms);
            encoder.close();
        }
    }

    public Object[] getCells() {
        return this.getGraphLayoutCache().getCells(this.getGraphLayoutCache().getAllViews());
    }

    public void readLayout(File file) throws FileNotFoundException, UmlGraphFileCorruptException {
        try {
            this.readLayout(new FileInputStream(file));
        }
        catch (UmlGraphLayoutCorruptException e) {
            throw new UmlGraphFileCorruptException(file);
        }
    }

    public void readLayout(InputStream in) throws UmlGraphLayoutCorruptException {
        XMLDecoder decoder = new XMLDecoder(in);
        if (E2EBuilder.development) {
            decoder.setExceptionListener(new ExceptionListener(){

                @Override
                public void exceptionThrown(Exception e) {
                    e.printStackTrace();
                }
            });
        }
        Object[] cells = this.getCells();
        try {
            ArrayList geoms = (ArrayList)decoder.readObject();
            decoder.close();
            for (int i = 0; i < geoms.size(); ++i) {
                Object geom = geoms.get(i);
                if (geom == null) continue;
                Object cell = cells[i];
                if (cell instanceof Edge) {
                    List points = (List)geom;
                    UmlGraphConstants.setPoints((Map)((Edge)cell).getAttributes(), (List)points);
                    continue;
                }
                if (!(cell instanceof GraphCell)) continue;
                UmlGraphConstants.setBounds((Map)((GraphCell)cell).getAttributes(), (Rectangle2D)((Rectangle2D)geom));
            }
            ((DefaultGraphModel)this.getModel()).cellsChanged(cells);
        }
        catch (Exception e) {
            throw new UmlGraphLayoutCorruptException(in);
        }
    }

    private void configure() {
        this.runDate = new Date().getTime();
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.setEditClickCount(2);
        this.setTolerance(0);
        this.setEditable(false);
        this.setDisconnectable(false);
        this.setDisconnectOnMove(false);
        this.setMoveOutOfGroups(false);
        this.setGroupsEditable(false);
        this.setSizeable(false);
        this.setDoubleBuffered(true);
        this.setAntiAliased(true);
        this.configureKeyListener();
        this.configureMouseListener();
        this.setHighlightColor(Color.YELLOW);
        this.setLockedHandleColor(Color.YELLOW);
    }

    private void configureKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object cell;
                if (UmlGraph.this.getSelectionCount() == 1 && (cell = UmlGraph.this.getSelectionCell()) instanceof CellWithContextMenu) {
                    KeyStroke accelerator = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                    AbstractCellAction<? extends CellWithContextMenu> action = ((CellWithContextMenu)cell).getContextMenu().getAction(accelerator);
                    if (action != null) {
                        action.actionPerformed(new ActionEvent(e.getSource(), e.getID(), action.getName(), e.getWhen(), e.getModifiers()));
                    }
                }
            }
        });
    }

    private void configureMouseListener() {
        this.addMouseListener(new MouseAdapter(){
            private Point startPoint;
            private boolean popupTrigger = false;

            @Override
            public void mousePressed(MouseEvent event) {
                this.startPoint = event.getPoint();
                this.popupTrigger = event.isPopupTrigger() || event.getButton() == 3;
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                Object o;
                if (this.startPoint != null && event.getPoint().distance(this.startPoint) <= (double)UmlGraph.this.tolerance && (o = UmlGraph.this.getCellForLocation(event.getX(), event.getY())) instanceof CellWithContextMenu) {
                    AbstractCellAction<? extends CellWithContextMenu> action;
                    CellWithContextMenu cell = (CellWithContextMenu)o;
                    if (event.getClickCount() == 1 && !this.maybeShowContextMenu(event, cell) && (action = cell.getDefaultAction()) != null) {
                        ActionEvent e = new ActionEvent(event.getSource(), 1001, (String)action.getValue("Name"), event.getWhen(), event.getModifiers());
                        action.actionPerformed(e);
                    }
                }
                this.startPoint = null;
                this.popupTrigger = false;
            }

            private boolean maybeShowContextMenu(MouseEvent event, CellWithContextMenu cell) {
                boolean show;
                ContextMenu<? extends CellWithContextMenu> contextMenu = cell.getContextMenu();
                boolean bl = show = contextMenu != null && (this.popupTrigger || event.isPopupTrigger() || event.getButton() == 3 || cell.isContextMenuAlwaysTriggered());
                if (show) {
                    contextMenu.show((Component)event.getSource(), event.getX(), event.getY());
                    event.consume();
                }
                return show;
            }
        });
    }

    private Object getCellForLocation(int x, int y) {
        Object o = this.getFirstCellForLocation(x, y);
        if (o instanceof GroupingCell) {
            o = this.getNextCellForLocation(o, x, y);
        }
        return o;
    }

    private static class UmlMarqueeHandler
    extends BasicMarqueeHandler {
        private UmlMarqueeHandler() {
        }

        public void mouseMoved(MouseEvent e) {
            Cursor cursor;
            UmlGraph graph = (UmlGraph)((Object)e.getSource());
            Object cell = graph.getCellForLocation(e.getX(), e.getY());
            if (cell instanceof CellWithContextMenu && (cursor = ((CellWithContextMenu)cell).getCursor()) != null) {
                graph.setCursor(cursor);
                e.consume();
            }
        }
    }
}

