/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing.tree;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.SelectUmlObjectEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeListener;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.TestcaseRoot;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.execute.SetConfigurationRequest;
import ch.e2e.builder.traceviewer.execute.SetConfigurationTransaction;
import ch.e2e.builder.traceviewer.swing.MainPanel;
import ch.e2e.builder.traceviewer.swing.tree.TestcaseTreeModel;
import ch.e2e.builder.traceviewer.swing.tree.TreeView;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.AsynchronousFolder;
import ch.e2e.builder.traceviewer.testcase.AsynchronousTestcaseRoot;
import ch.e2e.builder.traceviewer.testcase.event.ClearAsyncTestcaseFolderEvent;
import ch.e2e.builder.traceviewer.tree.menu.ClearAsyncTestcaseFolderExecuter;
import ch.e2e.builder.traceviewer.tree.menu.DeleteAsynchronousFolderEvent;
import ch.e2e.builder.traceviewer.tree.menu.DeleteAsynchronousTestcaseEvent;
import ch.e2e.builder.traceviewer.tree.menu.DeleteAsynchronousTestcaseExecuter;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public class AsynchronousTreeView
extends TreeView
implements TestcaseTreeListener {
    private SetConfigurationTransaction transaction;

    public AsynchronousTreeView(AsynchronousTestcaseRoot root, MainPanel main, TraceViewer traceViewer) {
        super((TestcaseRoot)root, main, (E2EBuilderModule)traceViewer);
        this.transaction = new SetConfigurationTransaction((E2EBuilderModule)traceViewer);
    }

    @Override
    protected void selectDiagram(SelectUmlObjectEvent event) {
        if (event.getTestcase() instanceof AbstractAsynchronousTestcase) {
            super.selectDiagram(event);
        }
    }

    @Override
    protected TestcaseTreeModel newTreeModel(TestcaseRoot root) {
        return new TestcaseTreeModel(root, this.getModule(), this);
    }

    @Override
    protected void addEventHandler() {
        E2EBuilderModule traceViewer = this.getModule();
        this.addActions();
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) throws EventExecutionVetoException {
                AsynchronousTreeView.this.refreshTree(event);
            }
        }, RefreshAsynchronousTreeEvent.class);
        EventController.register((EventExecuter)new ClearAsyncTestcaseFolderExecuter(traceViewer), ClearAsyncTestcaseFolderEvent.class);
        EventController.register((EventExecuter)new DeleteAsynchronousTestcaseExecuter(traceViewer), DeleteAsynchronousTestcaseEvent.class);
    }

    private void activateTrace(AsynchronousFolder folder) {
        for (TestcaseObject testcase : folder.getChildren().values()) {
            if (!(testcase instanceof AbstractAsyncTestcaseFolder)) continue;
            SetConfigurationRequest request = new SetConfigurationRequest((AbstractAsyncTestcaseFolder)testcase, TraceSettings.TraceLevel.Moderate, 10, null);
            EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)this.transaction, (Object)request));
        }
    }

    private void addActions() {
        InputMap inputMap = this.getTree().getInputMap(0);
        ActionMap actionMap = this.getTree().getActionMap();
        this.addDeleteAction(inputMap, actionMap);
    }

    private void addDeleteAction(InputMap inputMap, ActionMap actionMap) {
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "tracer.async.tree.node.delete");
        actionMap.put("tracer.async.tree.node.delete", new AbstractAction("tracer.async.tree.node.delete"){

            @Override
            public void actionPerformed(ActionEvent event) {
                TreePath path = AsynchronousTreeView.this.getSelectionPath();
                if (path != null) {
                    Object node = path.getLastPathComponent();
                    if (node instanceof AsynchronousFolder) {
                        EventController.fire((EventObject)((Object)new DeleteAsynchronousFolderEvent(this, path)));
                    } else if (node instanceof AbstractAsyncTestcaseFolder) {
                        EventController.fire((EventObject)new ClearAsyncTestcaseFolderEvent((Object)this, (AbstractAsyncTestcaseFolder)node));
                    } else if (node instanceof AbstractAsynchronousTestcase) {
                        EventController.fire((EventObject)((Object)new DeleteAsynchronousTestcaseEvent(this, (AbstractAsynchronousTestcase)node)));
                    }
                }
            }
        });
    }

    public void clearTestcase(TestcaseTreeEvent event) {
    }

    public void createTestcase(TestcaseTreeEvent event) {
    }

    public void copyTestcase(TestcaseTreeEvent event) {
    }

    public void deleteTestcase(TestcaseTreeEvent event) {
    }

    public void exportTestcase(TestcaseTreeEvent event) {
    }

    public void editPreferences(TestcaseTreeEvent event) {
    }

    public void mockBackendsManually(TestcaseTreeEvent event) {
    }

    public void mockBackends(TestcaseTreeEvent event) {
    }

    public void renameTestcase(TestcaseTreeEvent event) {
    }

    public void runTestcase(TestcaseTreeEvent event) {
    }
}

