/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.importer;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.io.E2EFileFilter;
import ch.e2e.builder.base.io.FileService;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputTextField;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.JideButton;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class WSDLImportDialog
extends E2EBuilderDialog {
    private static final String FILE_CHOOSER_BUTTON = "wsdl.import.dialog.file.chooser.button";
    private static final String MAX_NESTING_LEVEL_ITEM = "wsdl.import.max.nesting.level.item";
    private static final String URL_TOOLTIP = "wsdl.import.dialog.url.tooltip";
    private static final String FILE_CHOOSER_TOOLTIP = "wsdl.import.dialog.file.chooser.tooltip";
    private static final String MAX_NESTING_LEVEL_TOOLTIP = "wsdl.import.dialog.nesting.level.tooltip";
    private static final String IMPORT_TESTCASES_TOOLTIP = "wsdl.import.dialog.import.testcases.tooltip";
    private static final String KEY_URL_IMPORT = "url_import";
    private static final String DEFAULT_URL_IMPORT = null;
    private static final String KEY_FILE_IMPORT = "file_import";
    private static final File DEFAULT_FILE_IMPORT = null;
    private static final int MIN_NESTING_LEVEL = 1;
    private static final int MAX_NESTING_LEVEL = Integer.MAX_VALUE;
    public static final String KEY_USE_CUSTOM_HOST = "useCustomHost";
    public static final String KEY_CUSTOM_HOST = "customHost";
    public static final String CUSTOM_HOST_ITEM = "wsdl.import.dialog.custom.host.item";
    public static final String CUSTOM_HOST_TOOLTIP = "wsdl.import.dialog.custom.host.tooltip";
    private final E2EBuilderModule module;
    private InputTextField urlItem;
    private JCheckBox importTestcasesItem;
    private URL defaultUrl;
    private JSpinner nestingLevelItem;
    private JCheckBox useCustomHostItem;
    private InputTextField customHostItem;

    public WSDLImportDialog(E2EBuilderModule module) {
        super(module.getTranslation("wsdl.import.title"), module.getTranslation("wsdl.import.internaltitle"), module.getTranslation("wsdl.import.subtitle"), 3);
        this.module = module;
        this.createGUI();
        this.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    WSDLImportDialog.this.getModule().setProjectProperty(WSDLImportDialog.KEY_USE_CUSTOM_HOST, WSDLImportDialog.this.isUseCustomHost());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (!WSDLImportDialog.this.getCustomHost().isEmpty()) {
                    try {
                        WSDLImportDialog.this.getModule().setProjectProperty(WSDLImportDialog.KEY_CUSTOM_HOST, (Object)WSDLImportDialog.this.getCustomHost());
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    public URL getUrl() throws MalformedURLException {
        File file = new File(this.urlItem.getText());
        return (file.canRead() ? file.toURI() : URI.create(this.urlItem.getText())).toURL();
    }

    public int getNestingLevel() {
        return (Integer)this.nestingLevelItem.getValue();
    }

    public boolean isUseCustomHost() {
        return this.useCustomHostItem.isSelected();
    }

    public String getCustomHost() {
        return this.customHostItem.getText();
    }

    public boolean isImportTestcases() {
        return this.importTestcasesItem.isSelected();
    }

    public int showDialog() {
        String url = this.getModule().getProjectProperty(KEY_URL_IMPORT, DEFAULT_URL_IMPORT);
        this.setOkButtonEnabled(url != null);
        this.urlItem.setContent((Object)url);
        this.useCustomHostItem.setSelected(this.getModule().getProjectProperty(KEY_USE_CUSTOM_HOST, false));
        this.customHostItem.setContent((Object)this.getModule().getProjectProperty(KEY_CUSTOM_HOST, (String)null));
        try {
            this.defaultUrl = url == null || url.isEmpty() ? new File(System.getProperty("ch.e2e.builder.base.repository")).toURI().toURL() : URI.create(url).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return super.showDialog();
    }

    private void createGUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(0, 20, 0, 0));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridwidth = 0;
        c.insets = new Insets(5, 0, 5, 0);
        panel.add((Component)new JLabel(this.getModule().getTranslation("wsdl.import.message")), c);
        panel.add((Component)this.urlComponent(), c);
        panel.add((Component)this.nestingLevelComponent(), c);
        panel.add((Component)this.customHostComponent(), c);
        panel.add((Component)this.importTestcasesComponent(), c);
        this.add(panel, "Before");
    }

    private JComponent urlComponent() {
        JPanel urlPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.urlItem = new InputTextField(50);
        this.urlItem.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                String url = WSDLImportDialog.this.urlItem.getText();
                WSDLImportDialog.this.setOkButtonEnabled(url != null && !url.isEmpty());
            }
        });
        urlPanel.add((Component)this.urlItem);
        urlPanel.add((Component)((Object)new ChooserButton(this.module.getTranslation(FILE_CHOOSER_BUTTON, "..."))));
        urlPanel.setToolTipText(this.module.getTranslation(URL_TOOLTIP));
        return urlPanel;
    }

    private JComponent nestingLevelComponent() {
        JPanel nestingLevelPanel = new JPanel(new FlowLayout(3, 0, 0));
        JLabel nestingLevelLabel = new JLabel(this.module.getTranslation(MAX_NESTING_LEVEL_ITEM, "Max Nesting Level"));
        Insets insets = nestingLevelLabel.getInsets();
        insets.right += 5;
        nestingLevelLabel.setBorder(new EmptyBorder(insets));
        nestingLevelLabel.setToolTipText(this.module.getTranslation(MAX_NESTING_LEVEL_TOOLTIP));
        nestingLevelPanel.add(nestingLevelLabel);
        int nestingLevel = this.module.getGenericProjectProperty("wsdl.import.max.nesting.level", 8);
        if (nestingLevel < 1 || nestingLevel > Integer.MAX_VALUE) {
            nestingLevel = 8;
        }
        this.nestingLevelItem = new JSpinner(new SpinnerNumberModel(nestingLevel, 1, Integer.MAX_VALUE, 1));
        this.nestingLevelItem.setToolTipText(this.module.getTranslation(MAX_NESTING_LEVEL_TOOLTIP));
        SpinnerWheelSupport.installMouseWheelSupport((JSpinner)this.nestingLevelItem);
        nestingLevelPanel.add(this.nestingLevelItem);
        return nestingLevelPanel;
    }

    private JComponent customHostComponent() {
        JPanel customHostPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.useCustomHostItem = new JCheckBox(this.module.getTranslation(CUSTOM_HOST_ITEM, "Custom Host"));
        this.useCustomHostItem.setToolTipText(this.module.getTranslation(CUSTOM_HOST_TOOLTIP));
        customHostPanel.add(this.useCustomHostItem);
        this.customHostItem = new InputTextField(30);
        this.customHostItem.setToolTipText(this.module.getTranslation(CUSTOM_HOST_TOOLTIP));
        Insets insets = this.useCustomHostItem.getInsets();
        customHostPanel.setBorder(new EmptyBorder(0, -insets.left, 0, 0));
        customHostPanel.add((Component)this.customHostItem);
        return customHostPanel;
    }

    private JComponent importTestcasesComponent() {
        JPanel importTestcasesPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.importTestcasesItem = new JCheckBox(this.getModule().getTranslation("wsdl.import.testcases"));
        this.importTestcasesItem.setToolTipText(this.module.getTranslation(IMPORT_TESTCASES_TOOLTIP));
        Insets insets = this.importTestcasesItem.getInsets();
        importTestcasesPanel.setBorder(new EmptyBorder(0, -insets.left, 0, 0));
        importTestcasesPanel.add(this.importTestcasesItem);
        return importTestcasesPanel;
    }

    private class ChooserButton
    extends JideButton {
        private ChooserButton(String text) {
            super(text);
            this.setOpaque(true);
            this.setRolloverEnabled(false);
            this.setToolTipText(WSDLImportDialog.this.module.getTranslation(WSDLImportDialog.FILE_CHOOSER_TOOLTIP));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File wsdlFile;
                    File defaultFile = WSDLImportDialog.this.module.getProjectProperty(WSDLImportDialog.KEY_FILE_IMPORT, DEFAULT_FILE_IMPORT);
                    if (defaultFile == null) {
                        if (WSDLImportDialog.this.defaultUrl != null && "file".equals(WSDLImportDialog.this.defaultUrl.getProtocol())) {
                            try {
                                defaultFile = new File(WSDLImportDialog.this.defaultUrl.toURI());
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        } else {
                            defaultFile = new File(System.getProperty("ch.e2e.builder.base.repository"));
                        }
                    }
                    if ((wsdlFile = FileService.selectFile((File)defaultFile, (E2EFileFilter[])new E2EFileFilter[]{new WSDLFilter(), new WSDLFilesFilter(), new RepositoryFilesFilter()}, (String)WSDLImportDialog.this.module.getTranslation("wsdl.import.dialog.title"), (String)WSDLImportDialog.this.module.getTranslation("wsdl.import.dialog.subtitle"))) != null) {
                        WSDLImportDialog.this.urlItem.setContent((Object)wsdlFile.getPath());
                        try {
                            WSDLImportDialog.this.defaultUrl = wsdlFile.toURI().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        try {
                            WSDLImportDialog.this.module.setProjectProperty(WSDLImportDialog.KEY_URL_IMPORT, (Object)WSDLImportDialog.this.defaultUrl.toString());
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        try {
                            WSDLImportDialog.this.module.setProjectProperty(WSDLImportDialog.KEY_FILE_IMPORT, (Object)wsdlFile);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    private class RepositoryFilesFilter
    extends E2EFileFilter {
        private RepositoryFilesFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith("rep");
        }

        public String getDescription() {
            return WSDLImportDialog.this.getModule().getTranslation("wsdl.import.file.filter.repository.files");
        }

        public String getDefaultExtension() {
            return "rep";
        }
    }

    private class WSDLFilesFilter
    extends E2EFileFilter {
        private WSDLFilesFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith("wsdl");
        }

        public String getDescription() {
            return WSDLImportDialog.this.getModule().getTranslation("wsdl.import.file.filter.wsdl.files");
        }

        public String getDefaultExtension() {
            return "wsdl";
        }
    }

    private class WSDLFilter
    extends E2EFileFilter {
        private WSDLFilter() {
        }

        public String getDefaultExtension() {
            return "wsdl";
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith("wsdl") || f.getName().endsWith("rep");
        }

        public String getDescription() {
            return WSDLImportDialog.this.getModule().getTranslation("wsdl.import.file.filter.wsdl");
        }
    }
}

