import {Injectable} from '@angular/core';
import {ActivatedRouteSnapshot, CanActivate, RouterStateSnapshot, UrlTree} from '@angular/router';
import {SecurityService} from "@pas/app-core";
import {CurrentUserService} from "@pas/platform-communication";
import {ConfigurationService} from "@pas/xuml-communication";

@Injectable({
    providedIn: 'root'
})
export class SecurityGuard implements CanActivate {

    constructor(
        private currentUserService: CurrentUserService,
        private security: SecurityService,
        private configuration: ConfigurationService
    ) {
    }

    async canActivate(
        route: ActivatedRouteSnapshot,
        state: RouterStateSnapshot): Promise<boolean | UrlTree> {

        const roles = await this.getRoles();
        const user = await this.currentUserService.getCurrentUser();
        route.data.user.value = user;
        route.data.roles.value = roles;

        const userRoles = user.roles
            .map(roleId => Object.keys(roles).find(key => roles[key] == roleId))
            .filter(value => value != null);
        userRoles.push('__everyone__');

        this.security.setCurrentUserRoles(userRoles);

        return true;
    }

    private async getRoles(): Promise<{ [name: string]: string }> {
        const security = await this.configuration.getSecurity();
        return security.roles;
    }

}
